/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.utils.ByteUtils;

public class BlockLZ4CompressorOutputStream
extends CompressorOutputStream {
    private static final int MIN_BACK_REFERENCE_LENGTH = 4;
    private static final int MIN_OFFSET_OF_LAST_BACK_REFERENCE = 12;
    private final LZ77Compressor compressor;
    private final OutputStream os;
    private final byte[] oneByte = new byte[1];
    private boolean finished = false;
    private Deque<Pair> pairs = new LinkedList<Pair>();
    private Deque<byte[]> expandedBlocks = new LinkedList<byte[]>();

    public BlockLZ4CompressorOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, BlockLZ4CompressorOutputStream.createParameterBuilder().build());
    }

    public BlockLZ4CompressorOutputStream(OutputStream outputStream, Parameters parameters) throws IOException {
        this.os = outputStream;
        this.compressor = new LZ77Compressor(parameters, new LZ77Compressor.Callback(){

            @Override
            public void accept(LZ77Compressor.Block block) throws IOException {
                switch (block.getType()) {
                    case LITERAL: {
                        BlockLZ4CompressorOutputStream.this.addLiteralBlock((LZ77Compressor.LiteralBlock)block);
                        break;
                    }
                    case BACK_REFERENCE: {
                        BlockLZ4CompressorOutputStream.this.addBackReference((LZ77Compressor.BackReference)block);
                        break;
                    }
                    case EOD: {
                        BlockLZ4CompressorOutputStream.this.writeFinalLiteralBlock();
                    }
                }
            }
        });
    }

    @Override
    public void write(int n2) throws IOException {
        this.oneByte[0] = (byte)(n2 & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.compressor.compress(byArray, n2, n3);
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.os.close();
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.compressor.finish();
            this.finished = true;
        }
    }

    public void prefill(byte[] byArray, int n2, int n3) {
        if (n3 > 0) {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n2, n2 + n3);
            this.compressor.prefill(byArray2);
            this.recordLiteral(byArray2);
        }
    }

    private void addLiteralBlock(LZ77Compressor.LiteralBlock literalBlock) throws IOException {
        Pair pair = this.writeBlocksAndReturnUnfinishedPair(literalBlock.getLength());
        this.recordLiteral(pair.addLiteral(literalBlock));
        this.clearUnusedBlocksAndPairs();
    }

    private void addBackReference(LZ77Compressor.BackReference backReference) throws IOException {
        Pair pair = this.writeBlocksAndReturnUnfinishedPair(backReference.getLength());
        pair.setBackReference(backReference);
        this.recordBackReference(backReference);
        this.clearUnusedBlocksAndPairs();
    }

    private Pair writeBlocksAndReturnUnfinishedPair(int n2) throws IOException {
        this.writeWritablePairs(n2);
        Pair pair = this.pairs.peekLast();
        if (pair == null || pair.hasBackReference()) {
            pair = new Pair();
            this.pairs.addLast(pair);
        }
        return pair;
    }

    private void recordLiteral(byte[] byArray) {
        this.expandedBlocks.addFirst(byArray);
    }

    private void clearUnusedBlocksAndPairs() {
        this.clearUnusedBlocks();
        this.clearUnusedPairs();
    }

    private void clearUnusedBlocks() {
        int n2 = 0;
        int n3 = 0;
        for (byte[] byArray : this.expandedBlocks) {
            ++n3;
            if ((n2 += byArray.length) < 65536) continue;
            break;
        }
        int n4 = this.expandedBlocks.size();
        for (int i2 = n3; i2 < n4; ++i2) {
            this.expandedBlocks.removeLast();
        }
    }

    private void recordBackReference(LZ77Compressor.BackReference backReference) {
        this.expandedBlocks.addFirst(this.expand(backReference.getOffset(), backReference.getLength()));
    }

    private byte[] expand(int n2, int n3) {
        byte[] byArray = new byte[n3];
        if (n2 == 1) {
            byte[] byArray2 = this.expandedBlocks.peekFirst();
            byte by2 = byArray2[byArray2.length - 1];
            if (by2 != 0) {
                Arrays.fill(byArray, by2);
            }
        } else {
            this.expandFromList(byArray, n2, n3);
        }
        return byArray;
    }

    private void expandFromList(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = 0;
        while (n5 > 0) {
            int n7;
            int n8;
            byte[] byArray2 = null;
            if (n4 > 0) {
                int n9 = 0;
                for (byte[] byArray3 : this.expandedBlocks) {
                    if (byArray3.length + n9 >= n4) {
                        byArray2 = byArray3;
                        break;
                    }
                    n9 += byArray3.length;
                }
                if (byArray2 == null) {
                    throw new IllegalStateException("failed to find a block containing offset " + n2);
                }
                n8 = n9 + byArray2.length - n4;
                n7 = Math.min(n5, byArray2.length - n8);
            } else {
                byArray2 = byArray;
                n8 = -n4;
                n7 = Math.min(n5, n6 + n4);
            }
            System.arraycopy(byArray2, n8, byArray, n6, n7);
            n4 -= n7;
            n5 -= n7;
            n6 += n7;
        }
    }

    private void clearUnusedPairs() {
        Pair pair;
        int n2 = 0;
        int n3 = 0;
        Iterator<Pair> iterator = this.pairs.descendingIterator();
        while (iterator.hasNext()) {
            Pair pair2 = iterator.next();
            ++n3;
            if ((n2 += pair2.length()) < 65536) continue;
            break;
        }
        int n4 = this.pairs.size();
        for (int i2 = n3; i2 < n4 && (pair = this.pairs.peekFirst()).hasBeenWritten(); ++i2) {
            this.pairs.removeFirst();
        }
    }

    private void writeFinalLiteralBlock() throws IOException {
        this.rewriteLastPairs();
        for (Pair pair : this.pairs) {
            if (pair.hasBeenWritten()) continue;
            pair.writeTo(this.os);
        }
        this.pairs.clear();
    }

    private void writeWritablePairs(int n2) throws IOException {
        Pair pair2;
        int n3 = n2;
        Iterator<Pair> iterator = this.pairs.descendingIterator();
        while (iterator.hasNext() && !(pair2 = iterator.next()).hasBeenWritten()) {
            n3 += pair2.length();
        }
        for (Pair pair2 : this.pairs) {
            if (pair2.hasBeenWritten()) continue;
            if (!pair2.canBeWritten(n3 -= pair2.length())) break;
            pair2.writeTo(this.os);
        }
    }

    private void rewriteLastPairs() {
        int n2;
        int n3;
        Pair pair2;
        LinkedList<Pair> linkedList = new LinkedList<Pair>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        int n4 = 0;
        Iterator<Pair> iterator = this.pairs.descendingIterator();
        while (iterator.hasNext() && !(pair2 = iterator.next()).hasBeenWritten()) {
            n3 = pair2.length();
            linkedList2.addFirst(n3);
            linkedList.addFirst(pair2);
            if ((n4 += n3) < 12) continue;
            break;
        }
        for (Pair pair2 : linkedList) {
            this.pairs.remove(pair2);
        }
        int n5 = linkedList.size();
        int n6 = 0;
        for (n3 = 1; n3 < n5; ++n3) {
            n6 += ((Integer)linkedList2.get(n3)).intValue();
        }
        Pair pair3 = new Pair();
        if (n6 > 0) {
            pair3.prependLiteral(this.expand(n6, n6));
        }
        Pair pair4 = (Pair)linkedList.get(0);
        int n7 = 12 - n6;
        int n8 = n2 = pair4.hasBackReference() ? pair4.backReferenceLength() : 0;
        if (pair4.hasBackReference() && n2 >= 4 + n7) {
            pair3.prependLiteral(this.expand(n6 + n7, n7));
            this.pairs.add(pair4.splitWithNewBackReferenceLengthOf(n2 - n7));
        } else {
            if (pair4.hasBackReference()) {
                pair3.prependLiteral(this.expand(n6 + n2, n2));
            }
            pair4.prependTo(pair3);
        }
        this.pairs.add(pair3);
    }

    public static Parameters.Builder createParameterBuilder() {
        int n2 = 65535;
        return Parameters.builder(65536).withMinBackReferenceLength(4).withMaxBackReferenceLength(n2).withMaxOffset(n2).withMaxLiteralLength(n2);
    }

    static final class Pair {
        private final Deque<byte[]> literals = new LinkedList<byte[]>();
        private int brOffset;
        private int brLength;
        private boolean written;

        Pair() {
        }

        private void prependLiteral(byte[] byArray) {
            this.literals.addFirst(byArray);
        }

        byte[] addLiteral(LZ77Compressor.LiteralBlock literalBlock) {
            byte[] byArray = Arrays.copyOfRange(literalBlock.getData(), literalBlock.getOffset(), literalBlock.getOffset() + literalBlock.getLength());
            this.literals.add(byArray);
            return byArray;
        }

        void setBackReference(LZ77Compressor.BackReference backReference) {
            if (this.hasBackReference()) {
                throw new IllegalStateException();
            }
            this.brOffset = backReference.getOffset();
            this.brLength = backReference.getLength();
        }

        boolean hasBackReference() {
            return this.brOffset > 0;
        }

        boolean canBeWritten(int n2) {
            return this.hasBackReference() && n2 >= 16;
        }

        int length() {
            return this.literalLength() + this.brLength;
        }

        private boolean hasBeenWritten() {
            return this.written;
        }

        void writeTo(OutputStream outputStream) throws IOException {
            int n2 = this.literalLength();
            outputStream.write(Pair.lengths(n2, this.brLength));
            if (n2 >= 15) {
                Pair.writeLength(n2 - 15, outputStream);
            }
            for (byte[] byArray : this.literals) {
                outputStream.write(byArray);
            }
            if (this.hasBackReference()) {
                ByteUtils.toLittleEndian(outputStream, (long)this.brOffset, 2);
                if (this.brLength - 4 >= 15) {
                    Pair.writeLength(this.brLength - 4 - 15, outputStream);
                }
            }
            this.written = true;
        }

        private int literalLength() {
            int n2 = 0;
            for (byte[] byArray : this.literals) {
                n2 += byArray.length;
            }
            return n2;
        }

        private static int lengths(int n2, int n3) {
            int n4;
            int n5 = n4 = n2 < 15 ? n2 : 15;
            int n6 = n3 < 4 ? 0 : (n3 < 19 ? n3 - 4 : 15);
            return n4 << 4 | n6;
        }

        private static void writeLength(int n2, OutputStream outputStream) throws IOException {
            while (n2 >= 255) {
                outputStream.write(255);
                n2 -= 255;
            }
            outputStream.write(n2);
        }

        private int backReferenceLength() {
            return this.brLength;
        }

        private void prependTo(Pair pair) {
            Iterator<byte[]> iterator = this.literals.descendingIterator();
            while (iterator.hasNext()) {
                pair.prependLiteral(iterator.next());
            }
        }

        private Pair splitWithNewBackReferenceLengthOf(int n2) {
            Pair pair = new Pair();
            pair.literals.addAll(this.literals);
            pair.brOffset = this.brOffset;
            pair.brLength = n2;
            return pair;
        }
    }
}

