/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.XXHash32;
import org.apache.commons.compress.utils.ByteUtils;

public class FramedLZ4CompressorOutputStream
extends CompressorOutputStream {
    private static final byte[] END_MARK = new byte[4];
    private final byte[] oneByte = new byte[1];
    private final byte[] blockData;
    private final OutputStream out;
    private final Parameters params;
    private boolean finished = false;
    private int currentIndex = 0;
    private final XXHash32 contentHash = new XXHash32();
    private final XXHash32 blockHash;
    private byte[] blockDependencyBuffer;
    private int collectedBlockDependencyBytes;

    public FramedLZ4CompressorOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, Parameters.DEFAULT);
    }

    public FramedLZ4CompressorOutputStream(OutputStream outputStream, Parameters parameters) throws IOException {
        this.params = parameters;
        this.blockData = new byte[parameters.blockSize.getSize()];
        this.out = outputStream;
        this.blockHash = parameters.withBlockChecksum ? new XXHash32() : null;
        outputStream.write(FramedLZ4CompressorInputStream.LZ4_SIGNATURE);
        this.writeFrameDescriptor();
        this.blockDependencyBuffer = parameters.withBlockDependency ? new byte[65536] : null;
    }

    @Override
    public void write(int n2) throws IOException {
        this.oneByte[0] = (byte)(n2 & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.params.withContentChecksum) {
            this.contentHash.update(byArray, n2, n3);
        }
        if (this.currentIndex + n3 > this.blockData.length) {
            this.flushBlock();
            while (n3 > this.blockData.length) {
                System.arraycopy(byArray, n2, this.blockData, 0, this.blockData.length);
                n2 += this.blockData.length;
                n3 -= this.blockData.length;
                this.currentIndex = this.blockData.length;
                this.flushBlock();
            }
        }
        System.arraycopy(byArray, n2, this.blockData, this.currentIndex, n3);
        this.currentIndex += n3;
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.out.close();
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            if (this.currentIndex > 0) {
                this.flushBlock();
            }
            this.writeTrailer();
            this.finished = true;
        }
    }

    private void writeFrameDescriptor() throws IOException {
        int n2 = 64;
        if (!this.params.withBlockDependency) {
            n2 |= 0x20;
        }
        if (this.params.withContentChecksum) {
            n2 |= 4;
        }
        if (this.params.withBlockChecksum) {
            n2 |= 0x10;
        }
        this.out.write(n2);
        this.contentHash.update(n2);
        int n3 = this.params.blockSize.getIndex() << 4 & 0x70;
        this.out.write(n3);
        this.contentHash.update(n3);
        this.out.write((int)(this.contentHash.getValue() >> 8 & 0xFFL));
        this.contentHash.reset();
    }

    private void flushBlock() throws IOException {
        boolean bl2 = this.params.withBlockDependency;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Object object = new BlockLZ4CompressorOutputStream(byteArrayOutputStream, this.params.lz77params);){
            if (bl2) {
                ((BlockLZ4CompressorOutputStream)object).prefill(this.blockDependencyBuffer, this.blockDependencyBuffer.length - this.collectedBlockDependencyBytes, this.collectedBlockDependencyBytes);
            }
            ((BlockLZ4CompressorOutputStream)object).write(this.blockData, 0, this.currentIndex);
        }
        if (bl2) {
            this.appendToBlockDependencyBuffer(this.blockData, 0, this.currentIndex);
        }
        if (((Object)(object = (Object)byteArrayOutputStream.toByteArray())).length > this.currentIndex) {
            ByteUtils.toLittleEndian(this.out, (long)(this.currentIndex | Integer.MIN_VALUE), 4);
            this.out.write(this.blockData, 0, this.currentIndex);
            if (this.params.withBlockChecksum) {
                this.blockHash.update(this.blockData, 0, this.currentIndex);
            }
        } else {
            ByteUtils.toLittleEndian(this.out, (long)((Object)object).length, 4);
            this.out.write((byte[])object);
            if (this.params.withBlockChecksum) {
                this.blockHash.update((byte[])object, 0, ((Object)object).length);
            }
        }
        if (this.params.withBlockChecksum) {
            ByteUtils.toLittleEndian(this.out, this.blockHash.getValue(), 4);
            this.blockHash.reset();
        }
        this.currentIndex = 0;
    }

    private void writeTrailer() throws IOException {
        this.out.write(END_MARK);
        if (this.params.withContentChecksum) {
            ByteUtils.toLittleEndian(this.out, this.contentHash.getValue(), 4);
        }
    }

    private void appendToBlockDependencyBuffer(byte[] byArray, int n2, int n3) {
        if ((n3 = Math.min(n3, this.blockDependencyBuffer.length)) > 0) {
            int n4 = this.blockDependencyBuffer.length - n3;
            if (n4 > 0) {
                System.arraycopy(this.blockDependencyBuffer, n3, this.blockDependencyBuffer, 0, n4);
            }
            System.arraycopy(byArray, n2, this.blockDependencyBuffer, n4, n3);
            this.collectedBlockDependencyBytes = Math.min(this.collectedBlockDependencyBytes + n3, this.blockDependencyBuffer.length);
        }
    }

    public static class Parameters {
        private final BlockSize blockSize;
        private final boolean withContentChecksum;
        private final boolean withBlockChecksum;
        private final boolean withBlockDependency;
        private final org.apache.commons.compress.compressors.lz77support.Parameters lz77params;
        public static final Parameters DEFAULT = new Parameters(BlockSize.M4, true, false, false);

        public Parameters(BlockSize blockSize) {
            this(blockSize, true, false, false);
        }

        public Parameters(BlockSize blockSize, org.apache.commons.compress.compressors.lz77support.Parameters parameters) {
            this(blockSize, true, false, false, parameters);
        }

        public Parameters(BlockSize blockSize, boolean bl2, boolean bl3, boolean bl4) {
            this(blockSize, bl2, bl3, bl4, BlockLZ4CompressorOutputStream.createParameterBuilder().build());
        }

        public Parameters(BlockSize blockSize, boolean bl2, boolean bl3, boolean bl4, org.apache.commons.compress.compressors.lz77support.Parameters parameters) {
            this.blockSize = blockSize;
            this.withContentChecksum = bl2;
            this.withBlockChecksum = bl3;
            this.withBlockDependency = bl4;
            this.lz77params = parameters;
        }

        public String toString() {
            return "LZ4 Parameters with BlockSize " + (Object)((Object)this.blockSize) + ", withContentChecksum " + this.withContentChecksum + ", withBlockChecksum " + this.withBlockChecksum + ", withBlockDependency " + this.withBlockDependency;
        }
    }

    public static enum BlockSize {
        K64(65536, 4),
        K256(262144, 5),
        M1(0x100000, 6),
        M4(0x400000, 7);

        private final int size;
        private final int index;

        private BlockSize(int n3, int n4) {
            this.size = n3;
            this.index = n4;
        }

        int getSize() {
            return this.size;
        }

        int getIndex() {
            return this.index;
        }
    }
}

