/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;

public abstract class AbstractLZ77CompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final int windowSize;
    private final byte[] buf;
    private int writeIndex;
    private int readIndex;
    private final CountingInputStream in;
    private long bytesRemaining;
    private int backReferenceOffset;
    private int size = 0;
    private final byte[] oneByte = new byte[1];
    protected final ByteUtils.ByteSupplier supplier = new ByteUtils.ByteSupplier(){

        @Override
        public int getAsByte() throws IOException {
            return AbstractLZ77CompressorInputStream.this.readOneByte();
        }
    };

    public AbstractLZ77CompressorInputStream(InputStream inputStream, int n2) throws IOException {
        this.in = new CountingInputStream(inputStream);
        this.windowSize = n2;
        this.buf = new byte[3 * n2];
        this.readIndex = 0;
        this.writeIndex = 0;
        this.bytesRemaining = 0L;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() {
        return this.writeIndex - this.readIndex;
    }

    public int getSize() {
        return this.size;
    }

    public void prefill(byte[] byArray) {
        if (this.writeIndex != 0) {
            throw new IllegalStateException("the stream has already been read from, can't prefill anymore");
        }
        int n2 = Math.min(this.windowSize, byArray.length);
        System.arraycopy(byArray, byArray.length - n2, this.buf, 0, n2);
        this.writeIndex += n2;
        this.readIndex += n2;
    }

    @Override
    public long getCompressedCount() {
        return this.in.getBytesRead();
    }

    protected final void startLiteral(long l2) {
        this.bytesRemaining = l2;
    }

    protected final boolean hasMoreDataInBlock() {
        return this.bytesRemaining > 0L;
    }

    protected final int readLiteral(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.available();
        if (n3 > n4) {
            this.tryToReadLiteral(n3 - n4);
        }
        return this.readFromBuffer(byArray, n2, n3);
    }

    private void tryToReadLiteral(int n2) throws IOException {
        int n3 = Math.min((int)Math.min((long)n2, this.bytesRemaining), this.buf.length - this.writeIndex);
        int n4 = n3 > 0 ? IOUtils.readFully(this.in, this.buf, this.writeIndex, n3) : 0;
        this.count(n4);
        if (n3 != n4) {
            throw new IOException("Premature end of stream reading literal");
        }
        this.writeIndex += n3;
        this.bytesRemaining -= (long)n3;
    }

    private int readFromBuffer(byte[] byArray, int n2, int n3) {
        int n4 = Math.min(n3, this.available());
        if (n4 > 0) {
            System.arraycopy(this.buf, this.readIndex, byArray, n2, n4);
            this.readIndex += n4;
            if (this.readIndex > 2 * this.windowSize) {
                this.slideBuffer();
            }
        }
        this.size += n4;
        return n4;
    }

    private void slideBuffer() {
        System.arraycopy(this.buf, this.windowSize, this.buf, 0, this.windowSize * 2);
        this.writeIndex -= this.windowSize;
        this.readIndex -= this.windowSize;
    }

    protected final void startBackReference(int n2, long l2) {
        this.backReferenceOffset = n2;
        this.bytesRemaining = l2;
    }

    protected final int readBackReference(byte[] byArray, int n2, int n3) {
        int n4 = this.available();
        if (n3 > n4) {
            this.tryToCopy(n3 - n4);
        }
        return this.readFromBuffer(byArray, n2, n3);
    }

    private void tryToCopy(int n2) {
        int n3 = Math.min((int)Math.min((long)n2, this.bytesRemaining), this.buf.length - this.writeIndex);
        if (n3 != 0) {
            if (this.backReferenceOffset == 1) {
                byte by2 = this.buf[this.writeIndex - 1];
                Arrays.fill(this.buf, this.writeIndex, this.writeIndex + n3, by2);
                this.writeIndex += n3;
            } else if (n3 < this.backReferenceOffset) {
                System.arraycopy(this.buf, this.writeIndex - this.backReferenceOffset, this.buf, this.writeIndex, n3);
                this.writeIndex += n3;
            } else {
                int n4;
                int n5 = n3 / this.backReferenceOffset;
                for (n4 = 0; n4 < n5; ++n4) {
                    System.arraycopy(this.buf, this.writeIndex - this.backReferenceOffset, this.buf, this.writeIndex, this.backReferenceOffset);
                    this.writeIndex += this.backReferenceOffset;
                }
                n4 = n3 - this.backReferenceOffset * n5;
                if (n4 > 0) {
                    System.arraycopy(this.buf, this.writeIndex - this.backReferenceOffset, this.buf, this.writeIndex, n4);
                    this.writeIndex += n4;
                }
            }
        }
        this.bytesRemaining -= (long)n3;
    }

    protected final int readOneByte() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.count(1);
            return n2 & 0xFF;
        }
        return -1;
    }
}

