/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.compress.compressors.lz77support.Parameters;

public class LZ77Compressor {
    private static final Block THE_EOD = new EOD();
    static final int NUMBER_OF_BYTES_IN_HASH = 3;
    private static final int NO_MATCH = -1;
    private final Parameters params;
    private final Callback callback;
    private final byte[] window;
    private final int[] head;
    private final int[] prev;
    private final int wMask;
    private boolean initialized = false;
    private int currentPosition;
    private int lookahead = 0;
    private int insertHash = 0;
    private int blockStart = 0;
    private int matchStart = -1;
    private int missedInserts = 0;
    private static final int HASH_SIZE = 32768;
    private static final int HASH_MASK = Short.MAX_VALUE;
    private static final int H_SHIFT = 5;

    public LZ77Compressor(Parameters parameters, Callback callback) {
        if (parameters == null) {
            throw new NullPointerException("params must not be null");
        }
        if (callback == null) {
            throw new NullPointerException("callback must not be null");
        }
        this.params = parameters;
        this.callback = callback;
        int n2 = parameters.getWindowSize();
        this.window = new byte[n2 * 2];
        this.wMask = n2 - 1;
        this.head = new int[32768];
        Arrays.fill(this.head, -1);
        this.prev = new int[n2];
    }

    public void compress(byte[] byArray) throws IOException {
        this.compress(byArray, 0, byArray.length);
    }

    public void compress(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.params.getWindowSize();
        while (n3 > n4) {
            this.doCompress(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
        if (n3 > 0) {
            this.doCompress(byArray, n2, n3);
        }
    }

    public void finish() throws IOException {
        if (this.blockStart != this.currentPosition || this.lookahead > 0) {
            this.currentPosition += this.lookahead;
            this.flushLiteralBlock();
        }
        this.callback.accept(THE_EOD);
    }

    public void prefill(byte[] byArray) {
        if (this.currentPosition != 0 || this.lookahead != 0) {
            throw new IllegalStateException("the compressor has already started to accept data, can't prefill anymore");
        }
        int n2 = Math.min(this.params.getWindowSize(), byArray.length);
        System.arraycopy(byArray, byArray.length - n2, this.window, 0, n2);
        if (n2 >= 3) {
            this.initialize();
            int n3 = n2 - 3 + 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.insertString(i2);
            }
            this.missedInserts = 2;
        } else {
            this.missedInserts = n2;
        }
        this.blockStart = this.currentPosition = n2;
    }

    private int nextHash(int n2, byte by2) {
        int n3 = by2 & 0xFF;
        return (n2 << 5 ^ n3) & Short.MAX_VALUE;
    }

    private void doCompress(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.window.length - this.currentPosition - this.lookahead;
        if (n3 > n4) {
            this.slide();
        }
        System.arraycopy(byArray, n2, this.window, this.currentPosition + this.lookahead, n3);
        this.lookahead += n3;
        if (!this.initialized && this.lookahead >= this.params.getMinBackReferenceLength()) {
            this.initialize();
        }
        if (this.initialized) {
            this.compress();
        }
    }

    private void slide() throws IOException {
        int n2;
        int n3;
        int n4 = this.params.getWindowSize();
        if (this.blockStart != this.currentPosition && this.blockStart < n4) {
            this.flushLiteralBlock();
            this.blockStart = this.currentPosition;
        }
        System.arraycopy(this.window, n4, this.window, 0, n4);
        this.currentPosition -= n4;
        this.matchStart -= n4;
        this.blockStart -= n4;
        for (n3 = 0; n3 < 32768; ++n3) {
            n2 = this.head[n3];
            this.head[n3] = n2 >= n4 ? n2 - n4 : -1;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.prev[n3];
            this.prev[n3] = n2 >= n4 ? n2 - n4 : -1;
        }
    }

    private void initialize() {
        for (int i2 = 0; i2 < 2; ++i2) {
            this.insertHash = this.nextHash(this.insertHash, this.window[i2]);
        }
        this.initialized = true;
    }

    private void compress() throws IOException {
        int n2 = this.params.getMinBackReferenceLength();
        boolean bl2 = this.params.getLazyMatching();
        int n3 = this.params.getLazyMatchingThreshold();
        while (this.lookahead >= n2) {
            this.catchUpMissedInserts();
            int n4 = 0;
            int n5 = this.insertString(this.currentPosition);
            if (n5 != -1 && n5 - this.currentPosition <= this.params.getMaxOffset()) {
                n4 = this.longestMatch(n5);
                if (bl2 && n4 <= n3 && this.lookahead > n2) {
                    n4 = this.longestMatchForNextPosition(n4);
                }
            }
            if (n4 >= n2) {
                if (this.blockStart != this.currentPosition) {
                    this.flushLiteralBlock();
                    this.blockStart = -1;
                }
                this.flushBackReference(n4);
                this.insertStringsInMatch(n4);
                this.lookahead -= n4;
                this.currentPosition += n4;
                this.blockStart = this.currentPosition;
                continue;
            }
            --this.lookahead;
            ++this.currentPosition;
            if (this.currentPosition - this.blockStart < this.params.getMaxLiteralLength()) continue;
            this.flushLiteralBlock();
            this.blockStart = this.currentPosition;
        }
    }

    private int insertString(int n2) {
        int n3;
        this.insertHash = this.nextHash(this.insertHash, this.window[n2 - 1 + 3]);
        this.prev[n2 & this.wMask] = n3 = this.head[this.insertHash];
        this.head[this.insertHash] = n2;
        return n3;
    }

    private int longestMatchForNextPosition(int n2) {
        int n3 = this.matchStart;
        int n4 = this.insertHash;
        --this.lookahead;
        ++this.currentPosition;
        int n5 = this.insertString(this.currentPosition);
        int n6 = this.prev[this.currentPosition & this.wMask];
        int n7 = this.longestMatch(n5);
        if (n7 <= n2) {
            n7 = n2;
            this.matchStart = n3;
            this.head[this.insertHash] = n6;
            this.insertHash = n4;
            --this.currentPosition;
            ++this.lookahead;
        }
        return n7;
    }

    private void insertStringsInMatch(int n2) {
        int n3 = Math.min(n2 - 1, this.lookahead - 3);
        for (int i2 = 1; i2 <= n3; ++i2) {
            this.insertString(this.currentPosition + i2);
        }
        this.missedInserts = n2 - n3 - 1;
    }

    private void catchUpMissedInserts() {
        while (this.missedInserts > 0) {
            this.insertString(this.currentPosition - this.missedInserts--);
        }
    }

    private void flushBackReference(int n2) throws IOException {
        this.callback.accept(new BackReference(this.currentPosition - this.matchStart, n2));
    }

    private void flushLiteralBlock() throws IOException {
        this.callback.accept(new LiteralBlock(this.window, this.blockStart, this.currentPosition - this.blockStart));
    }

    private int longestMatch(int n2) {
        int n3 = this.params.getMinBackReferenceLength();
        int n4 = n3 - 1;
        int n5 = Math.min(this.params.getMaxBackReferenceLength(), this.lookahead);
        int n6 = Math.max(0, this.currentPosition - this.params.getMaxOffset());
        int n7 = Math.min(n5, this.params.getNiceBackReferenceLength());
        int n8 = this.params.getMaxCandidates();
        for (int i2 = 0; i2 < n8 && n2 >= n6; ++i2) {
            int n9 = 0;
            for (int i3 = 0; i3 < n5 && this.window[n2 + i3] == this.window[this.currentPosition + i3]; ++i3) {
                ++n9;
            }
            if (n9 > n4) {
                n4 = n9;
                this.matchStart = n2;
                if (n9 >= n7) break;
            }
            n2 = this.prev[n2 & this.wMask];
        }
        return n4;
    }

    public static interface Callback {
        public void accept(Block var1) throws IOException;
    }

    public static final class EOD
    extends Block {
        @Override
        public Block.BlockType getType() {
            return Block.BlockType.EOD;
        }
    }

    public static final class BackReference
    extends Block {
        private final int offset;
        private final int length;

        public BackReference(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public Block.BlockType getType() {
            return Block.BlockType.BACK_REFERENCE;
        }

        public String toString() {
            return "BackReference with offset " + this.offset + " and length " + this.length;
        }
    }

    public static final class LiteralBlock
    extends Block {
        private final byte[] data;
        private final int offset;
        private final int length;

        public LiteralBlock(byte[] byArray, int n2, int n3) {
            this.data = byArray;
            this.offset = n2;
            this.length = n3;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public Block.BlockType getType() {
            return Block.BlockType.LITERAL;
        }

        public String toString() {
            return "LiteralBlock starting at " + this.offset + " with length " + this.length;
        }
    }

    public static abstract class Block {
        public abstract BlockType getType();

        public static enum BlockType {
            LITERAL,
            BACK_REFERENCE,
            EOD;

        }
    }
}

