/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.commons.compress.compressors.pack200.StreamBridge;
import org.apache.commons.compress.utils.IOUtils;

public class Pack200CompressorInputStream
extends CompressorInputStream {
    private final InputStream originalInput;
    private final StreamBridge streamBridge;
    private static final byte[] CAFE_DOOD = new byte[]{-54, -2, -48, 13};
    private static final int SIG_LENGTH = CAFE_DOOD.length;

    public Pack200CompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorInputStream(InputStream inputStream, Pack200Strategy pack200Strategy) throws IOException {
        this(inputStream, null, pack200Strategy, null);
    }

    public Pack200CompressorInputStream(InputStream inputStream, Map<String, String> map) throws IOException {
        this(inputStream, Pack200Strategy.IN_MEMORY, map);
    }

    public Pack200CompressorInputStream(InputStream inputStream, Pack200Strategy pack200Strategy, Map<String, String> map) throws IOException {
        this(inputStream, null, pack200Strategy, map);
    }

    public Pack200CompressorInputStream(File file) throws IOException {
        this(file, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorInputStream(File file, Pack200Strategy pack200Strategy) throws IOException {
        this(null, file, pack200Strategy, null);
    }

    public Pack200CompressorInputStream(File file, Map<String, String> map) throws IOException {
        this(file, Pack200Strategy.IN_MEMORY, map);
    }

    public Pack200CompressorInputStream(File file, Pack200Strategy pack200Strategy, Map<String, String> map) throws IOException {
        this(null, file, pack200Strategy, map);
    }

    private Pack200CompressorInputStream(InputStream inputStream, File file, Pack200Strategy pack200Strategy, Map<String, String> map) throws IOException {
        this.originalInput = inputStream;
        this.streamBridge = pack200Strategy.newStreamBridge();
        try (JarOutputStream jarOutputStream = new JarOutputStream(this.streamBridge);){
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            if (map != null) {
                unpacker.properties().putAll(map);
            }
            if (file == null) {
                unpacker.unpack((InputStream)new FilterInputStream(inputStream){

                    @Override
                    public void close() {
                    }
                }, jarOutputStream);
            } else {
                unpacker.unpack(file, jarOutputStream);
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.streamBridge.getInput().read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.streamBridge.getInput().read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.streamBridge.getInput().read(byArray, n2, n3);
    }

    @Override
    public int available() throws IOException {
        return this.streamBridge.getInput().available();
    }

    @Override
    public boolean markSupported() {
        try {
            return this.streamBridge.getInput().markSupported();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void mark(int n2) {
        try {
            this.streamBridge.getInput().mark(n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void reset() throws IOException {
        this.streamBridge.getInput().reset();
    }

    @Override
    public long skip(long l2) throws IOException {
        return IOUtils.skip(this.streamBridge.getInput(), l2);
    }

    @Override
    public void close() throws IOException {
        try {
            this.streamBridge.stop();
        }
        finally {
            if (this.originalInput != null) {
                this.originalInput.close();
            }
        }
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < SIG_LENGTH) {
            return false;
        }
        for (int i2 = 0; i2 < SIG_LENGTH; ++i2) {
            if (byArray[i2] == CAFE_DOOD[i2]) continue;
            return false;
        }
        return true;
    }
}

