/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.lz77support.AbstractLZ77CompressorInputStream;
import org.apache.commons.compress.utils.ByteUtils;

public class SnappyCompressorInputStream
extends AbstractLZ77CompressorInputStream {
    private static final int TAG_MASK = 3;
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    private final int size;
    private int uncompressedBytesRemaining;
    private State state = State.NO_BLOCK;
    private boolean endReached = false;

    public SnappyCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 32768);
    }

    public SnappyCompressorInputStream(InputStream inputStream, int n2) throws IOException {
        super(inputStream, n2);
        this.uncompressedBytesRemaining = this.size = (int)this.readSize();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.endReached) {
            return -1;
        }
        switch (this.state) {
            case NO_BLOCK: {
                this.fill();
                return this.read(byArray, n2, n3);
            }
            case IN_LITERAL: {
                int n4 = this.readLiteral(byArray, n2, n3);
                if (!this.hasMoreDataInBlock()) {
                    this.state = State.NO_BLOCK;
                }
                return n4 > 0 ? n4 : this.read(byArray, n2, n3);
            }
            case IN_BACK_REFERENCE: {
                int n5 = this.readBackReference(byArray, n2, n3);
                if (!this.hasMoreDataInBlock()) {
                    this.state = State.NO_BLOCK;
                }
                return n5 > 0 ? n5 : this.read(byArray, n2, n3);
            }
        }
        throw new IOException("Unknown stream state " + (Object)((Object)this.state));
    }

    private void fill() throws IOException {
        if (this.uncompressedBytesRemaining == 0) {
            this.endReached = true;
            return;
        }
        int n2 = this.readOneByte();
        if (n2 == -1) {
            throw new IOException("Premature end of stream reading block start");
        }
        int n3 = 0;
        int n4 = 0;
        switch (n2 & 3) {
            case 0: {
                n3 = this.readLiteralLength(n2);
                this.uncompressedBytesRemaining -= n3;
                this.startLiteral(n3);
                this.state = State.IN_LITERAL;
                break;
            }
            case 1: {
                n3 = 4 + (n2 >> 2 & 7);
                this.uncompressedBytesRemaining -= n3;
                n4 = (n2 & 0xE0) << 3;
                n2 = this.readOneByte();
                if (n2 == -1) {
                    throw new IOException("Premature end of stream reading back-reference length");
                }
                this.startBackReference(n4 |= n2, n3);
                this.state = State.IN_BACK_REFERENCE;
                break;
            }
            case 2: {
                n3 = (n2 >> 2) + 1;
                this.uncompressedBytesRemaining -= n3;
                n4 = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
                this.startBackReference(n4, n3);
                this.state = State.IN_BACK_REFERENCE;
                break;
            }
            case 3: {
                n3 = (n2 >> 2) + 1;
                this.uncompressedBytesRemaining -= n3;
                n4 = (int)ByteUtils.fromLittleEndian(this.supplier, 4) & Integer.MAX_VALUE;
                this.startBackReference(n4, n3);
                this.state = State.IN_BACK_REFERENCE;
                break;
            }
        }
    }

    private int readLiteralLength(int n2) throws IOException {
        int n3;
        switch (n2 >> 2) {
            case 60: {
                n3 = this.readOneByte();
                if (n3 != -1) break;
                throw new IOException("Premature end of stream reading literal length");
            }
            case 61: {
                n3 = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
                break;
            }
            case 62: {
                n3 = (int)ByteUtils.fromLittleEndian(this.supplier, 3);
                break;
            }
            case 63: {
                n3 = (int)ByteUtils.fromLittleEndian(this.supplier, 4);
                break;
            }
            default: {
                n3 = n2 >> 2;
            }
        }
        return n3 + 1;
    }

    private long readSize() throws IOException {
        int n2 = 0;
        long l2 = 0L;
        int n3 = 0;
        do {
            if ((n3 = this.readOneByte()) == -1) {
                throw new IOException("Premature end of stream reading size");
            }
            l2 |= (long)((n3 & 0x7F) << n2++ * 7);
        } while (0 != (n3 & 0x80));
        return l2;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private static enum State {
        NO_BLOCK,
        IN_LITERAL,
        IN_BACK_REFERENCE;

    }
}

