/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.tukaani.xz.SingleXZInputStream;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZInputStream;

public class XZCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < XZ.HEADER_MAGIC.length) {
            return false;
        }
        for (int i2 = 0; i2 < XZ.HEADER_MAGIC.length; ++i2) {
            if (byArray[i2] == XZ.HEADER_MAGIC[i2]) continue;
            return false;
        }
        return true;
    }

    public XZCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean bl2) throws IOException {
        this(inputStream, bl2, -1);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean bl2, int n2) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = bl2 ? new XZInputStream((InputStream)this.countingStream, n2) : new SingleXZInputStream((InputStream)this.countingStream, n2);
    }

    @Override
    public int read() throws IOException {
        try {
            int n2 = this.in.read();
            this.count(n2 == -1 ? -1 : 1);
            return n2;
        }
        catch (org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), memoryLimitException);
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = this.in.read(byArray, n2, n3);
            this.count(n4);
            return n4;
        }
        catch (org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), memoryLimitException);
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        try {
            return IOUtils.skip(this.in, l2);
        }
        catch (org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), memoryLimitException);
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }
}

