/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteUtils {
    private ByteUtils() {
    }

    public static long fromLittleEndian(byte[] byArray) {
        return ByteUtils.fromLittleEndian(byArray, 0, byArray.length);
    }

    public static long fromLittleEndian(byte[] byArray, int n2, int n3) {
        ByteUtils.checkReadLength(n3);
        long l2 = 0L;
        for (int i2 = 0; i2 < n3; ++i2) {
            l2 |= ((long)byArray[n2 + i2] & 0xFFL) << 8 * i2;
        }
        return l2;
    }

    public static long fromLittleEndian(InputStream inputStream, int n2) throws IOException {
        ByteUtils.checkReadLength(n2);
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = inputStream.read();
            if (l3 == -1L) {
                throw new IOException("premature end of data");
            }
            l2 |= l3 << i2 * 8;
        }
        return l2;
    }

    public static long fromLittleEndian(ByteSupplier byteSupplier, int n2) throws IOException {
        ByteUtils.checkReadLength(n2);
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = byteSupplier.getAsByte();
            if (l3 == -1L) {
                throw new IOException("premature end of data");
            }
            l2 |= l3 << i2 * 8;
        }
        return l2;
    }

    public static long fromLittleEndian(DataInput dataInput, int n2) throws IOException {
        ByteUtils.checkReadLength(n2);
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = dataInput.readUnsignedByte();
            l2 |= l3 << i2 * 8;
        }
        return l2;
    }

    public static void toLittleEndian(byte[] byArray, long l2, int n2, int n3) {
        long l3 = l2;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2 + i2] = (byte)(l3 & 0xFFL);
            l3 >>= 8;
        }
    }

    public static void toLittleEndian(OutputStream outputStream, long l2, int n2) throws IOException {
        long l3 = l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            outputStream.write((int)(l3 & 0xFFL));
            l3 >>= 8;
        }
    }

    public static void toLittleEndian(ByteConsumer byteConsumer, long l2, int n2) throws IOException {
        long l3 = l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            byteConsumer.accept((int)(l3 & 0xFFL));
            l3 >>= 8;
        }
    }

    public static void toLittleEndian(DataOutput dataOutput, long l2, int n2) throws IOException {
        long l3 = l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.write((int)(l3 & 0xFFL));
            l3 >>= 8;
        }
    }

    private static final void checkReadLength(int n2) {
        if (n2 > 8) {
            throw new IllegalArgumentException("can't read more than eight bytes into a long value");
        }
    }

    public static class OutputStreamByteConsumer
    implements ByteConsumer {
        private final OutputStream os;

        public OutputStreamByteConsumer(OutputStream outputStream) {
            this.os = outputStream;
        }

        @Override
        public void accept(int n2) throws IOException {
            this.os.write(n2);
        }
    }

    public static class InputStreamByteSupplier
    implements ByteSupplier {
        private final InputStream is;

        public InputStreamByteSupplier(InputStream inputStream) {
            this.is = inputStream;
        }

        @Override
        public int getAsByte() throws IOException {
            return this.is.read();
        }
    }

    public static interface ByteConsumer {
        public void accept(int var1) throws IOException;
    }

    public static interface ByteSupplier {
        public int getAsByte() throws IOException;
    }
}

