/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ServiceLoaderIterator<E>
implements Iterator<E> {
    private E nextServiceLoader;
    private final Class<E> service;
    private final Iterator<E> serviceLoaderIterator;

    public ServiceLoaderIterator(Class<E> clazz) {
        this(clazz, ClassLoader.getSystemClassLoader());
    }

    public ServiceLoaderIterator(Class<E> clazz, ClassLoader classLoader) {
        this.service = clazz;
        ServiceLoader<E> serviceLoader = ServiceLoader.load(clazz, classLoader);
        this.serviceLoaderIterator = serviceLoader.iterator();
        this.nextServiceLoader = null;
    }

    private boolean getNextServiceLoader() {
        while (this.nextServiceLoader == null) {
            try {
                if (!this.serviceLoaderIterator.hasNext()) {
                    return false;
                }
                this.nextServiceLoader = this.serviceLoaderIterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                throw serviceConfigurationError;
            }
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.getNextServiceLoader();
    }

    @Override
    public E next() {
        if (!this.getNextServiceLoader()) {
            throw new NoSuchElementException("No more elements for service " + this.service.getName());
        }
        E e2 = this.nextServiceLoader;
        this.nextServiceLoader = null;
        return e2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("service=" + this.service.getName());
    }
}

