/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BCJDecoder;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.CountingInputStream;
import org.tukaani.xz.DeltaDecoder;
import org.tukaani.xz.FilterCoder;
import org.tukaani.xz.FilterDecoder;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.LZMA2Decoder;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.RawCoder;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;

class BlockInputStream
extends InputStream {
    private final DataInputStream inData;
    private final CountingInputStream inCounted;
    private InputStream filterChain;
    private final Check check;
    private final boolean verifyCheck;
    private long uncompressedSizeInHeader = -1L;
    private long compressedSizeInHeader = -1L;
    private long compressedSizeLimit;
    private final int headerSize;
    private long uncompressedSize = 0L;
    private boolean endReached = false;
    private final byte[] tempBuf = new byte[1];

    public BlockInputStream(InputStream inputStream, Check check, boolean bl2, int n2, long l2, long l3, ArrayCache arrayCache) throws IOException, IndexIndicatorException {
        int n3;
        long l4;
        int n4;
        this.check = check;
        this.verifyCheck = bl2;
        this.inData = new DataInputStream(inputStream);
        byte[] byArray = new byte[1024];
        this.inData.readFully(byArray, 0, 1);
        if (byArray[0] == 0) {
            throw new IndexIndicatorException();
        }
        this.headerSize = 4 * ((byArray[0] & 0xFF) + 1);
        this.inData.readFully(byArray, 1, this.headerSize - 1);
        if (!DecoderUtil.isCRC32Valid(byArray, 0, this.headerSize - 4, this.headerSize - 4)) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        if ((byArray[1] & 0x3C) != 0) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        int n5 = (byArray[1] & 3) + 1;
        long[] lArray = new long[n5];
        byte[][] byArrayArray = new byte[n5][];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 2, this.headerSize - 6);
        try {
            this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check.getSize();
            if ((byArray[1] & 0x40) != 0) {
                this.compressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (this.compressedSizeInHeader == 0L || this.compressedSizeInHeader > this.compressedSizeLimit) {
                    throw new CorruptedInputException();
                }
                this.compressedSizeLimit = this.compressedSizeInHeader;
            }
            if ((byArray[1] & 0x80) != 0) {
                this.uncompressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
            }
            for (n4 = 0; n4 < n5; ++n4) {
                lArray[n4] = DecoderUtil.decodeVLI(byteArrayInputStream);
                l4 = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (l4 > (long)byteArrayInputStream.available()) {
                    throw new CorruptedInputException();
                }
                byArrayArray[n4] = new byte[(int)l4];
                byteArrayInputStream.read(byArrayArray[n4]);
            }
        }
        catch (IOException iOException) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        for (n4 = byteArrayInputStream.available(); n4 > 0; --n4) {
            if (byteArrayInputStream.read() == 0) continue;
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        if (l2 != -1L) {
            n4 = this.headerSize + check.getSize();
            if ((long)n4 >= l2) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            l4 = l2 - (long)n4;
            if (l4 > this.compressedSizeLimit || this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != l4) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            if (this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != l3) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            this.compressedSizeLimit = l4;
            this.compressedSizeInHeader = l4;
            this.uncompressedSizeInHeader = l3;
        }
        FilterCoder[] filterCoderArray = new FilterDecoder[lArray.length];
        for (n3 = 0; n3 < filterCoderArray.length; ++n3) {
            if (lArray[n3] == 33L) {
                filterCoderArray[n3] = new LZMA2Decoder(byArrayArray[n3]);
                continue;
            }
            if (lArray[n3] == 3L) {
                filterCoderArray[n3] = new DeltaDecoder(byArrayArray[n3]);
                continue;
            }
            if (BCJDecoder.isBCJFilterID(lArray[n3])) {
                filterCoderArray[n3] = new BCJDecoder(lArray[n3], byArrayArray[n3]);
                continue;
            }
            throw new UnsupportedOptionsException("Unknown Filter ID " + lArray[n3]);
        }
        RawCoder.validate(filterCoderArray);
        if (n2 >= 0) {
            n3 = 0;
            for (int i2 = 0; i2 < filterCoderArray.length; ++i2) {
                n3 += filterCoderArray[i2].getMemoryUsage();
            }
            if (n3 > n2) {
                throw new MemoryLimitException(n3, n2);
            }
        }
        this.inCounted = new CountingInputStream(inputStream);
        this.filterChain = this.inCounted;
        for (n3 = filterCoderArray.length - 1; n3 >= 0; --n3) {
            this.filterChain = filterCoderArray[n3].getInputStream(this.filterChain, arrayCache);
        }
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.endReached) {
            return -1;
        }
        int n4 = this.filterChain.read(byArray, n2, n3);
        if (n4 > 0) {
            if (this.verifyCheck) {
                this.check.update(byArray, n2, n4);
            }
            this.uncompressedSize += (long)n4;
            long l2 = this.inCounted.getSize();
            if (l2 < 0L || l2 > this.compressedSizeLimit || this.uncompressedSize < 0L || this.uncompressedSizeInHeader != -1L && this.uncompressedSize > this.uncompressedSizeInHeader) {
                throw new CorruptedInputException();
            }
            if (n4 < n3 || this.uncompressedSize == this.uncompressedSizeInHeader) {
                if (this.filterChain.read() != -1) {
                    throw new CorruptedInputException();
                }
                this.validate();
                this.endReached = true;
            }
        } else if (n4 == -1) {
            this.validate();
            this.endReached = true;
        }
        return n4;
    }

    private void validate() throws IOException {
        long l2 = this.inCounted.getSize();
        if (this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != l2 || this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != this.uncompressedSize) {
            throw new CorruptedInputException();
        }
        while ((l2++ & 3L) != 0L) {
            if (this.inData.readUnsignedByte() == 0) continue;
            throw new CorruptedInputException();
        }
        byte[] byArray = new byte[this.check.getSize()];
        this.inData.readFully(byArray);
        if (this.verifyCheck && !Arrays.equals(this.check.finish(), byArray)) {
            throw new CorruptedInputException("Integrity check (" + this.check.getName() + ") does not match");
        }
    }

    public int available() throws IOException {
        return this.filterChain.available();
    }

    public void close() {
        block2: {
            try {
                this.filterChain.close();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.filterChain = null;
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.inCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

