/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CountingOutputStream;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.EncoderUtil;

class BlockOutputStream
extends FinishableOutputStream {
    private final OutputStream out;
    private final CountingOutputStream outCounted;
    private FinishableOutputStream filterChain;
    private final Check check;
    private final int headerSize;
    private final long compressedSizeLimit;
    private long uncompressedSize = 0L;
    private final byte[] tempBuf = new byte[1];

    public BlockOutputStream(OutputStream outputStream, FilterEncoder[] filterEncoderArray, Check check, ArrayCache arrayCache) throws IOException {
        this.out = outputStream;
        this.check = check;
        this.outCounted = new CountingOutputStream(outputStream);
        this.filterChain = this.outCounted;
        for (int i2 = filterEncoderArray.length - 1; i2 >= 0; --i2) {
            this.filterChain = filterEncoderArray[i2].getOutputStream(this.filterChain, arrayCache);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(filterEncoderArray.length - 1);
        for (int i3 = 0; i3 < filterEncoderArray.length; ++i3) {
            EncoderUtil.encodeVLI(byteArrayOutputStream, filterEncoderArray[i3].getFilterID());
            byte[] byArray = filterEncoderArray[i3].getFilterProps();
            EncoderUtil.encodeVLI(byteArrayOutputStream, byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        while ((byteArrayOutputStream.size() & 3) != 0) {
            byteArrayOutputStream.write(0);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.headerSize = byArray.length + 4;
        if (this.headerSize > 1024) {
            throw new UnsupportedOptionsException();
        }
        byArray[0] = (byte)(byArray.length / 4);
        outputStream.write(byArray);
        EncoderUtil.writeCRC32(outputStream, byArray);
        this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check.getSize();
    }

    public void write(int n2) throws IOException {
        this.tempBuf[0] = (byte)n2;
        this.write(this.tempBuf, 0, 1);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.filterChain.write(byArray, n2, n3);
        this.check.update(byArray, n2, n3);
        this.uncompressedSize += (long)n3;
        this.validate();
    }

    public void flush() throws IOException {
        this.filterChain.flush();
        this.validate();
    }

    public void finish() throws IOException {
        this.filterChain.finish();
        this.validate();
        long l2 = this.outCounted.getSize();
        while ((l2 & 3L) != 0L) {
            this.out.write(0);
            ++l2;
        }
        this.out.write(this.check.finish());
    }

    private void validate() throws IOException {
        long l2 = this.outCounted.getSize();
        if (l2 < 0L || l2 > this.compressedSizeLimit || this.uncompressedSize < 0L) {
            throw new XZIOException("XZ Stream has grown too big");
        }
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.outCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

