/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.util.ArrayList;
import java.util.List;
import org.tukaani.xz.ArrayCache;

public class ResettableArrayCache
extends ArrayCache {
    private final ArrayCache arrayCache;
    private final List<byte[]> byteArrays;
    private final List<int[]> intArrays;

    public ResettableArrayCache(ArrayCache arrayCache) {
        this.arrayCache = arrayCache;
        if (arrayCache == ArrayCache.getDummyCache()) {
            this.byteArrays = null;
            this.intArrays = null;
        } else {
            this.byteArrays = new ArrayList<byte[]>();
            this.intArrays = new ArrayList<int[]>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray(int n2, boolean bl2) {
        byte[] byArray = this.arrayCache.getByteArray(n2, bl2);
        if (this.byteArrays != null) {
            List<byte[]> list = this.byteArrays;
            synchronized (list) {
                this.byteArrays.add(byArray);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putArray(byte[] byArray) {
        if (this.byteArrays != null) {
            List<byte[]> list = this.byteArrays;
            synchronized (list) {
                int n2 = this.byteArrays.lastIndexOf(byArray);
                if (n2 != -1) {
                    this.byteArrays.remove(n2);
                }
            }
            this.arrayCache.putArray(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getIntArray(int n2, boolean bl2) {
        int[] nArray = this.arrayCache.getIntArray(n2, bl2);
        if (this.intArrays != null) {
            List<int[]> list = this.intArrays;
            synchronized (list) {
                this.intArrays.add(nArray);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putArray(int[] nArray) {
        if (this.intArrays != null) {
            List<int[]> list = this.intArrays;
            synchronized (list) {
                int n2 = this.intArrays.lastIndexOf(nArray);
                if (n2 != -1) {
                    this.intArrays.remove(n2);
                }
            }
            this.arrayCache.putArray(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.byteArrays != null) {
            int n2;
            List<byte[]> list = this.byteArrays;
            synchronized (list) {
                for (n2 = this.byteArrays.size() - 1; n2 >= 0; --n2) {
                    this.arrayCache.putArray(this.byteArrays.get(n2));
                }
                this.byteArrays.clear();
            }
            list = this.intArrays;
            synchronized (list) {
                for (n2 = this.intArrays.size() - 1; n2 >= 0; --n2) {
                    this.arrayCache.putArray(this.intArrays.get(n2));
                }
                this.intArrays.clear();
            }
        }
    }
}

