/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BlockInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.IndexHash;

public class SingleXZInputStream
extends InputStream {
    private InputStream in;
    private final ArrayCache arrayCache;
    private final int memoryLimit;
    private final StreamFlags streamHeaderFlags;
    private final Check check;
    private final boolean verifyCheck;
    private BlockInputStream blockDecoder = null;
    private final IndexHash indexHash = new IndexHash();
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    private static byte[] readStreamHeader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(inputStream).readFully(byArray);
        return byArray;
    }

    public SingleXZInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public SingleXZInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public SingleXZInputStream(InputStream inputStream, int n2) throws IOException {
        this(inputStream, n2, true);
    }

    public SingleXZInputStream(InputStream inputStream, int n2, ArrayCache arrayCache) throws IOException {
        this(inputStream, n2, true, arrayCache);
    }

    public SingleXZInputStream(InputStream inputStream, int n2, boolean bl2) throws IOException {
        this(inputStream, n2, bl2, ArrayCache.getDefaultCache());
    }

    public SingleXZInputStream(InputStream inputStream, int n2, boolean bl2, ArrayCache arrayCache) throws IOException {
        this(inputStream, n2, bl2, SingleXZInputStream.readStreamHeader(inputStream), arrayCache);
    }

    SingleXZInputStream(InputStream inputStream, int n2, boolean bl2, byte[] byArray, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.in = inputStream;
        this.memoryLimit = n2;
        this.verifyCheck = bl2;
        this.streamHeaderFlags = DecoderUtil.decodeStreamHeader(byArray);
        this.check = Check.getInstance(this.streamHeaderFlags.checkType);
    }

    public int getCheckType() {
        return this.streamHeaderFlags.checkType;
    }

    public String getCheckName() {
        return this.check.getName();
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block12: {
            if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.endReached) {
                return -1;
            }
            n4 = 0;
            try {
                while (n3 > 0) {
                    int n5;
                    if (this.blockDecoder == null) {
                        try {
                            this.blockDecoder = new BlockInputStream(this.in, this.check, this.verifyCheck, this.memoryLimit, -1L, -1L, this.arrayCache);
                        }
                        catch (IndexIndicatorException indexIndicatorException) {
                            this.indexHash.validate(this.in);
                            this.validateStreamFooter();
                            this.endReached = true;
                            return n4 > 0 ? n4 : -1;
                        }
                    }
                    if ((n5 = this.blockDecoder.read(byArray, n2, n3)) > 0) {
                        n4 += n5;
                        n2 += n5;
                        n3 -= n5;
                        continue;
                    }
                    if (n5 != -1) continue;
                    this.indexHash.add(this.blockDecoder.getUnpaddedSize(), this.blockDecoder.getUncompressedSize());
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                if (n4 != 0) break block12;
                throw iOException;
            }
        }
        return n4;
    }

    private void validateStreamFooter() throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(this.in).readFully(byArray);
        StreamFlags streamFlags = DecoderUtil.decodeStreamFooter(byArray);
        if (!DecoderUtil.areStreamFlagsEqual(this.streamHeaderFlags, streamFlags) || this.indexHash.getIndexSize() != streamFlags.backwardSize) {
            throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
        }
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.blockDecoder == null ? 0 : this.blockDecoder.available();
    }

    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl2) throws IOException {
        if (this.in != null) {
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            try {
                if (bl2) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

