/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lzma;

import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;
import org.tukaani.xz.lzma.LZMAEncoder;
import org.tukaani.xz.lzma.Optimum;
import org.tukaani.xz.lzma.State;
import org.tukaani.xz.rangecoder.RangeEncoder;

final class LZMAEncoderNormal
extends LZMAEncoder {
    private static final int OPTS = 4096;
    private static final int EXTRA_SIZE_BEFORE = 4096;
    private static final int EXTRA_SIZE_AFTER = 4096;
    private final Optimum[] opts = new Optimum[4096];
    private int optCur = 0;
    private int optEnd = 0;
    private Matches matches;
    private final int[] repLens = new int[4];
    private final State nextState = new State();

    static int getMemoryUsage(int n2, int n3, int n4) {
        return LZEncoder.getMemoryUsage(n2, Math.max(n3, 4096), 4096, 273, n4) + 256;
    }

    LZMAEncoderNormal(RangeEncoder rangeEncoder, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ArrayCache arrayCache) {
        super(rangeEncoder, LZEncoder.getInstance(n5, Math.max(n6, 4096), 4096, n7, 273, n8, n9, arrayCache), n2, n3, n4, n5, n7);
        for (int i2 = 0; i2 < 4096; ++i2) {
            this.opts[i2] = new Optimum();
        }
    }

    public void reset() {
        this.optCur = 0;
        this.optEnd = 0;
        super.reset();
    }

    private int convertOpts() {
        this.optEnd = this.optCur;
        int n2 = this.opts[this.optCur].optPrev;
        do {
            Optimum optimum = this.opts[this.optCur];
            if (optimum.prev1IsLiteral) {
                this.opts[n2].optPrev = this.optCur;
                this.opts[n2].backPrev = -1;
                this.optCur = n2--;
                if (optimum.hasPrev2) {
                    this.opts[n2].optPrev = n2 + 1;
                    this.opts[n2].backPrev = optimum.backPrev2;
                    this.optCur = n2;
                    n2 = optimum.optPrev2;
                }
            }
            int n3 = this.opts[n2].optPrev;
            this.opts[n2].optPrev = this.optCur;
            this.optCur = n2;
            n2 = n3;
        } while (this.optCur > 0);
        this.optCur = this.opts[0].optPrev;
        this.back = this.opts[this.optCur].backPrev;
        return this.optCur;
    }

    int getNextSymbol() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.optCur < this.optEnd) {
            int n8 = this.opts[this.optCur].optPrev - this.optCur;
            this.optCur = this.opts[this.optCur].optPrev;
            this.back = this.opts[this.optCur].backPrev;
            return n8;
        }
        assert (this.optCur == this.optEnd);
        this.optCur = 0;
        this.optEnd = 0;
        this.back = -1;
        if (this.readAhead == -1) {
            this.matches = this.getMatches();
        }
        if ((n7 = Math.min(this.lz.getAvail(), 273)) < 2) {
            return 1;
        }
        int n9 = 0;
        for (n6 = 0; n6 < 4; ++n6) {
            this.repLens[n6] = this.lz.getMatchLen(this.reps[n6], n7);
            if (this.repLens[n6] < 2) {
                this.repLens[n6] = 0;
                continue;
            }
            if (this.repLens[n6] <= this.repLens[n9]) continue;
            n9 = n6;
        }
        if (this.repLens[n9] >= this.niceLen) {
            this.back = n9;
            this.skip(this.repLens[n9] - 1);
            return this.repLens[n9];
        }
        n6 = 0;
        int n10 = 0;
        if (this.matches.count > 0) {
            n6 = this.matches.len[this.matches.count - 1];
            n10 = this.matches.dist[this.matches.count - 1];
            if (n6 >= this.niceLen) {
                this.back = n10 + 4;
                this.skip(n6 - 1);
                return n6;
            }
        }
        int n11 = this.lz.getByte(0);
        int n12 = this.lz.getByte(this.reps[0] + 1);
        if (n6 < 2 && n11 != n12 && this.repLens[n9] < 2) {
            return 1;
        }
        int n13 = this.lz.getPos();
        int n14 = n13 & this.posMask;
        int n15 = this.lz.getByte(1);
        int n16 = this.literalEncoder.getPrice(n11, n12, n15, n13, this.state);
        this.opts[1].set1(n16, 0, -1);
        n15 = this.getAnyMatchPrice(this.state, n14);
        n16 = this.getAnyRepPrice(n15, this.state);
        if (n12 == n11 && (n5 = this.getShortRepPrice(n16, this.state, n14)) < this.opts[1].price) {
            this.opts[1].set1(n5, 0, 0);
        }
        this.optEnd = Math.max(n6, this.repLens[n9]);
        if (this.optEnd < 2) {
            assert (this.optEnd == 0) : this.optEnd;
            this.back = this.opts[1].backPrev;
            return 1;
        }
        this.updatePrices();
        this.opts[0].state.set(this.state);
        System.arraycopy(this.reps, 0, this.opts[0].reps, 0, 4);
        for (n5 = this.optEnd; n5 >= 2; --n5) {
            this.opts[n5].reset();
        }
        for (n5 = 0; n5 < 4; ++n5) {
            n4 = this.repLens[n5];
            if (n4 < 2) continue;
            n3 = this.getLongRepPrice(n16, n5, this.state, n14);
            do {
                if ((n2 = n3 + this.repLenEncoder.getPrice(n4, n14)) >= this.opts[n4].price) continue;
                this.opts[n4].set1(n2, 0, n5);
            } while (--n4 >= 2);
        }
        n5 = Math.max(this.repLens[0] + 1, 2);
        if (n5 <= n6) {
            n4 = this.getNormalMatchPrice(n15, this.state);
            n3 = 0;
            while (n5 > this.matches.len[n3]) {
                ++n3;
            }
            while (true) {
                int n17;
                if ((n17 = this.getMatchAndLenPrice(n4, n2 = this.matches.dist[n3], n5, n14)) < this.opts[n5].price) {
                    this.opts[n5].set1(n17, 0, n2 + 4);
                }
                if (n5 == this.matches.len[n3] && ++n3 == this.matches.count) break;
                ++n5;
            }
        }
        n7 = Math.min(this.lz.getAvail(), 4095);
        while (++this.optCur < this.optEnd) {
            this.matches = this.getMatches();
            if (this.matches.count > 0 && this.matches.len[this.matches.count - 1] >= this.niceLen) break;
            n14 = ++n13 & this.posMask;
            this.updateOptStateAndReps();
            n15 = this.opts[this.optCur].price + this.getAnyMatchPrice(this.opts[this.optCur].state, n14);
            n16 = this.getAnyRepPrice(n15, this.opts[this.optCur].state);
            this.calc1BytePrices(n13, n14, --n7, n16);
            if (n7 < 2) continue;
            n5 = this.calcLongRepPrices(n13, n14, n7, n16);
            if (this.matches.count <= 0) continue;
            this.calcNormalMatchPrices(n13, n14, n7, n15, n5);
        }
        return this.convertOpts();
    }

    private void updateOptStateAndReps() {
        int n2 = this.opts[this.optCur].optPrev;
        assert (n2 < this.optCur);
        if (this.opts[this.optCur].prev1IsLiteral) {
            --n2;
            if (this.opts[this.optCur].hasPrev2) {
                this.opts[this.optCur].state.set(this.opts[this.opts[this.optCur].optPrev2].state);
                if (this.opts[this.optCur].backPrev2 < 4) {
                    this.opts[this.optCur].state.updateLongRep();
                } else {
                    this.opts[this.optCur].state.updateMatch();
                }
            } else {
                this.opts[this.optCur].state.set(this.opts[n2].state);
            }
            this.opts[this.optCur].state.updateLiteral();
        } else {
            this.opts[this.optCur].state.set(this.opts[n2].state);
        }
        if (n2 == this.optCur - 1) {
            assert (this.opts[this.optCur].backPrev == 0 || this.opts[this.optCur].backPrev == -1);
            if (this.opts[this.optCur].backPrev == 0) {
                this.opts[this.optCur].state.updateShortRep();
            } else {
                this.opts[this.optCur].state.updateLiteral();
            }
            System.arraycopy(this.opts[n2].reps, 0, this.opts[this.optCur].reps, 0, 4);
        } else {
            int n3;
            if (this.opts[this.optCur].prev1IsLiteral && this.opts[this.optCur].hasPrev2) {
                n2 = this.opts[this.optCur].optPrev2;
                n3 = this.opts[this.optCur].backPrev2;
                this.opts[this.optCur].state.updateLongRep();
            } else {
                n3 = this.opts[this.optCur].backPrev;
                if (n3 < 4) {
                    this.opts[this.optCur].state.updateLongRep();
                } else {
                    this.opts[this.optCur].state.updateMatch();
                }
            }
            if (n3 < 4) {
                int n4;
                this.opts[this.optCur].reps[0] = this.opts[n2].reps[n3];
                for (n4 = 1; n4 <= n3; ++n4) {
                    this.opts[this.optCur].reps[n4] = this.opts[n2].reps[n4 - 1];
                }
                while (n4 < 4) {
                    this.opts[this.optCur].reps[n4] = this.opts[n2].reps[n4];
                    ++n4;
                }
            } else {
                this.opts[this.optCur].reps[0] = n3 - 4;
                System.arraycopy(this.opts[n2].reps, 0, this.opts[this.optCur].reps, 1, 3);
            }
        }
    }

    private void calc1BytePrices(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        boolean bl2 = false;
        int n9 = this.lz.getByte(0);
        int n10 = this.opts[this.optCur].price + this.literalEncoder.getPrice(n9, n8 = this.lz.getByte(this.opts[this.optCur].reps[0] + 1), this.lz.getByte(1), n2, this.opts[this.optCur].state);
        if (n10 < this.opts[this.optCur + 1].price) {
            this.opts[this.optCur + 1].set1(n10, this.optCur, -1);
            bl2 = true;
        }
        if (n8 == n9 && (this.opts[this.optCur + 1].optPrev == this.optCur || this.opts[this.optCur + 1].backPrev != 0) && (n7 = this.getShortRepPrice(n5, this.opts[this.optCur].state, n3)) <= this.opts[this.optCur + 1].price) {
            this.opts[this.optCur + 1].set1(n7, this.optCur, 0);
            bl2 = true;
        }
        if (!bl2 && n8 != n9 && n4 > 2 && (n6 = this.lz.getMatchLen(1, this.opts[this.optCur].reps[0], n7 = Math.min(this.niceLen, n4 - 1))) >= 2) {
            this.nextState.set(this.opts[this.optCur].state);
            this.nextState.updateLiteral();
            int n11 = n2 + 1 & this.posMask;
            int n12 = n10 + this.getLongRepAndLenPrice(0, n6, this.nextState, n11);
            int n13 = this.optCur + 1 + n6;
            while (this.optEnd < n13) {
                this.opts[++this.optEnd].reset();
            }
            if (n12 < this.opts[n13].price) {
                this.opts[n13].set2(n12, this.optCur, 0);
            }
        }
    }

    private int calcLongRepPrices(int n2, int n3, int n4, int n5) {
        int n6 = 2;
        int n7 = Math.min(n4, this.niceLen);
        for (int i2 = 0; i2 < 4; ++i2) {
            int n8;
            int n9;
            int n10 = this.lz.getMatchLen(this.opts[this.optCur].reps[i2], n7);
            if (n10 < 2) continue;
            while (this.optEnd < this.optCur + n10) {
                this.opts[++this.optEnd].reset();
            }
            int n11 = this.getLongRepPrice(n5, i2, this.opts[this.optCur].state, n3);
            for (n9 = n10; n9 >= 2; --n9) {
                n8 = n11 + this.repLenEncoder.getPrice(n9, n3);
                if (n8 >= this.opts[this.optCur + n9].price) continue;
                this.opts[this.optCur + n9].set1(n8, this.optCur, i2);
            }
            if (i2 == 0) {
                n6 = n10 + 1;
            }
            if ((n8 = this.lz.getMatchLen(n10 + 1, this.opts[this.optCur].reps[i2], n9 = Math.min(this.niceLen, n4 - n10 - 1))) < 2) continue;
            int n12 = n11 + this.repLenEncoder.getPrice(n10, n3);
            this.nextState.set(this.opts[this.optCur].state);
            this.nextState.updateLongRep();
            int n13 = this.lz.getByte(n10, 0);
            int n14 = this.lz.getByte(0);
            int n15 = this.lz.getByte(n10, 1);
            n12 += this.literalEncoder.getPrice(n13, n14, n15, n2 + n10, this.nextState);
            this.nextState.updateLiteral();
            int n16 = n2 + n10 + 1 & this.posMask;
            n12 += this.getLongRepAndLenPrice(0, n8, this.nextState, n16);
            int n17 = this.optCur + n10 + 1 + n8;
            while (this.optEnd < n17) {
                this.opts[++this.optEnd].reset();
            }
            if (n12 >= this.opts[n17].price) continue;
            this.opts[n17].set3(n12, this.optCur, i2, n10, 0);
        }
        return n6;
    }

    private void calcNormalMatchPrices(int n2, int n3, int n4, int n5, int n6) {
        if (this.matches.len[this.matches.count - 1] > n4) {
            this.matches.count = 0;
            while (this.matches.len[this.matches.count] < n4) {
                ++this.matches.count;
            }
            this.matches.len[this.matches.count++] = n4;
        }
        if (this.matches.len[this.matches.count - 1] < n6) {
            return;
        }
        while (this.optEnd < this.optCur + this.matches.len[this.matches.count - 1]) {
            this.opts[++this.optEnd].reset();
        }
        int n7 = this.getNormalMatchPrice(n5, this.opts[this.optCur].state);
        int n8 = 0;
        while (n6 > this.matches.len[n8]) {
            ++n8;
        }
        int n9 = n6;
        while (true) {
            int n10;
            int n11;
            if ((n11 = this.getMatchAndLenPrice(n7, n10 = this.matches.dist[n8], n9, n3)) < this.opts[this.optCur + n9].price) {
                this.opts[this.optCur + n9].set1(n11, this.optCur, n10 + 4);
            }
            if (n9 == this.matches.len[n8]) {
                int n12 = Math.min(this.niceLen, n4 - n9 - 1);
                int n13 = this.lz.getMatchLen(n9 + 1, n10, n12);
                if (n13 >= 2) {
                    this.nextState.set(this.opts[this.optCur].state);
                    this.nextState.updateMatch();
                    int n14 = this.lz.getByte(n9, 0);
                    int n15 = this.lz.getByte(0);
                    int n16 = this.lz.getByte(n9, 1);
                    int n17 = n11 + this.literalEncoder.getPrice(n14, n15, n16, n2 + n9, this.nextState);
                    this.nextState.updateLiteral();
                    int n18 = n2 + n9 + 1 & this.posMask;
                    n17 += this.getLongRepAndLenPrice(0, n13, this.nextState, n18);
                    int n19 = this.optCur + n9 + 1 + n13;
                    while (this.optEnd < n19) {
                        this.opts[++this.optEnd].reset();
                    }
                    if (n17 < this.opts[n19].price) {
                        this.opts[n19].set3(n17, this.optCur, n10 + 4, n9, 0);
                    }
                }
                if (++n8 == this.matches.count) break;
            }
            ++n9;
        }
    }
}

