/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.NtlmAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyServerConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.internal.NexusHttpRoutePlanner;

public class ConfigurationCustomizer
extends ComponentSupport
implements HttpClientPlan.Customizer {
    private static final Function<String, String> GLOB_STRING_TO_REGEXP_STRING = new Function<String, String>(){

        public String apply(String input) {
            return "(" + input.toLowerCase(Locale.US).replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*?").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + ")";
        }
    };
    private final HttpClientConfiguration configuration;

    static {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String prot = this.getRequestingProtocol().toLowerCase();
                    String host = System.getProperty(String.valueOf(prot) + ".proxyHost", "");
                    String port = System.getProperty(String.valueOf(prot) + ".proxyPort", "80");
                    String user = System.getProperty(String.valueOf(prot) + ".proxyUser", "");
                    String password = System.getProperty(String.valueOf(prot) + ".proxyPassword", "");
                    if (this.getRequestingHost().equalsIgnoreCase(host) && Integer.parseInt(port) == this.getRequestingPort()) {
                        return new PasswordAuthentication(user, password.toCharArray());
                    }
                }
                return null;
            }
        });
    }

    public ConfigurationCustomizer(HttpClientConfiguration configuration) {
        this.configuration = (HttpClientConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    @Override
    public void customize(HttpClientPlan plan) {
        Preconditions.checkNotNull((Object)((Object)plan));
        if (this.configuration.getConnection() != null) {
            this.apply(this.configuration.getConnection(), plan);
        }
        if (this.configuration.getProxy() != null) {
            this.apply(this.configuration.getProxy(), plan);
        }
        if (this.configuration.getAuthentication() != null) {
            this.apply(this.configuration.getAuthentication(), plan, null);
        }
    }

    private void apply(ConnectionConfiguration connection, HttpClientPlan plan) {
        if (connection.getTimeout() != null) {
            int timeout = connection.getTimeout().toMillisI();
            plan.getSocket().setSoTimeout(timeout);
            plan.getRequest().setConnectTimeout(timeout);
            plan.getRequest().setSocketTimeout(timeout);
        }
        if (connection.getMaximumRetries() != null) {
            plan.getClient().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(connection.getMaximumRetries().intValue(), false));
        }
        if (connection.getUserAgentSuffix() != null) {
            Preconditions.checkState((plan.getUserAgentBase() != null ? 1 : 0) != 0, (Object)"Default User-Agent not set");
            plan.setUserAgentSuffix(connection.getUserAgentSuffix());
        }
        if (Boolean.TRUE.equals(connection.getUseTrustStore())) {
            plan.getAttributes().put("nexus.httpclient.ssl.trustStore", Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(connection.getEnableCircularRedirects())) {
            plan.getRequest().setCircularRedirectsAllowed(true);
        }
        if (Boolean.TRUE.equals(connection.getEnableCookies())) {
            plan.getRequest().setCookieSpec("default");
        }
    }

    private void apply(ProxyConfiguration proxy, HttpClientPlan plan) {
        ProxyServerConfiguration https;
        ProxyServerConfiguration http = proxy.getHttp();
        if (http != null && http.isEnabled()) {
            HttpHost host = new HttpHost(http.getHost(), http.getPort());
            if (http.getAuthentication() != null) {
                this.apply(http.getAuthentication(), plan, host);
            }
        }
        if ((https = proxy.getHttps()) != null && https.isEnabled()) {
            HttpHost host = new HttpHost(https.getHost(), https.getPort());
            if (https.getAuthentication() != null) {
                this.apply(https.getAuthentication(), plan, host);
            }
        }
        plan.getClient().setRoutePlanner((HttpRoutePlanner)this.createRoutePlanner(proxy));
    }

    @VisibleForTesting
    NexusHttpRoutePlanner createRoutePlanner(ProxyConfiguration proxy) {
        ProxyServerConfiguration https;
        HashMap<String, HttpHost> proxies = new HashMap<String, HttpHost>(2);
        ProxyServerConfiguration http = proxy.getHttp();
        if (http != null && http.isEnabled()) {
            HttpHost host = new HttpHost(http.getHost(), http.getPort());
            proxies.put("http", host);
            proxies.put("https", host);
        }
        if ((https = proxy.getHttps()) != null && https.isEnabled()) {
            HttpHost host = new HttpHost(https.getHost(), https.getPort());
            proxies.put("https", host);
        }
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (proxy.getNonProxyHosts() != null) {
            patterns.addAll(Arrays.asList(proxy.getNonProxyHosts()));
        }
        String nonProxyPatternString = Joiner.on((String)"|").join(Iterables.transform(patterns, GLOB_STRING_TO_REGEXP_STRING));
        Pattern nonProxyPattern = null;
        if (!Strings2.isBlank((String)nonProxyPatternString)) {
            try {
                nonProxyPattern = Pattern.compile(nonProxyPatternString, 2);
            }
            catch (PatternSyntaxException e) {
                this.log.warn("Invalid non-proxy host regex: {}, using defaults", (Object)nonProxyPatternString, (Object)e);
            }
        }
        return new NexusHttpRoutePlanner(proxies, nonProxyPattern);
    }

    private void apply(AuthenticationConfiguration authentication, HttpClientPlan plan, @Nullable HttpHost proxyHost) {
        UsernamePasswordCredentials credentials;
        ImmutableList authSchemes;
        if (authentication instanceof UsernameAuthenticationConfiguration) {
            UsernameAuthenticationConfiguration auth = (UsernameAuthenticationConfiguration)authentication;
            authSchemes = ImmutableList.of((Object)"Digest", (Object)"Basic");
            credentials = new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword());
        } else if (authentication instanceof NtlmAuthenticationConfiguration) {
            NtlmAuthenticationConfiguration auth = (NtlmAuthenticationConfiguration)authentication;
            authSchemes = ImmutableList.of((Object)"NTLM", (Object)"Digest", (Object)"Basic");
            credentials = new NTCredentials(auth.getUsername(), auth.getPassword(), auth.getHost(), auth.getDomain());
        } else {
            throw new IllegalArgumentException("Unsupported authentication configuration: " + authentication);
        }
        if (proxyHost != null) {
            plan.addCredentials(new AuthScope(proxyHost), (Credentials)credentials);
            plan.getRequest().setProxyPreferredAuthSchemes((Collection)authSchemes);
        } else {
            plan.addCredentials(AuthScope.ANY, (Credentials)credentials);
            plan.getRequest().setTargetPreferredAuthSchemes((Collection)authSchemes);
        }
    }
}

