/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.config;

import javax.annotation.Nullable;
import javax.validation.Valid;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyConfiguration;

public class HttpClientConfiguration
extends AbstractEntity
implements Cloneable {
    @Valid
    @Nullable
    private ConnectionConfiguration connection;
    @Valid
    @Nullable
    private ProxyConfiguration proxy;
    @Valid
    @Nullable
    private AuthenticationConfiguration authentication;

    @Nullable
    public ConnectionConfiguration getConnection() {
        return this.connection;
    }

    public void setConnection(@Nullable ConnectionConfiguration connection) {
        this.connection = connection;
    }

    @Nullable
    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    @Nullable
    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(@Nullable AuthenticationConfiguration authentication) {
        this.authentication = authentication;
    }

    public HttpClientConfiguration copy() {
        try {
            HttpClientConfiguration copy = (HttpClientConfiguration)this.clone();
            if (this.connection != null) {
                copy.connection = this.connection.copy();
            }
            if (this.proxy != null) {
                copy.proxy = this.proxy.copy();
            }
            if (this.authentication != null) {
                copy.authentication = this.authentication.copy();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "connection=" + this.connection + ", proxy=" + this.proxy + ", authentication=" + this.authentication + '}';
    }
}

