/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.config;

import javax.annotation.Nullable;
import javax.validation.Valid;
import org.hibernate.validator.constraints.NotBlank;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.validation.constraint.PortNumber;

public class ProxyServerConfiguration
implements Cloneable {
    private boolean enabled;
    @NotBlank
    private String host;
    @PortNumber
    private int port;
    @Valid
    @Nullable
    private AuthenticationConfiguration authentication;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Nullable
    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(@Nullable AuthenticationConfiguration authentication) {
        this.authentication = authentication;
    }

    public ProxyServerConfiguration copy() {
        try {
            ProxyServerConfiguration copy = (ProxyServerConfiguration)this.clone();
            if (this.authentication != null) {
                copy.authentication = this.authentication.copy();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "enabled=" + this.enabled + ", host='" + this.host + '\'' + ", port=" + this.port + ", authentication=" + this.authentication + '}';
    }
}

