/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.httpclient.internal;

import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusRedirectStrategy
extends DefaultRedirectStrategy {
    public static final String CONTENT_RETRIEVAL_MARKER_KEY = String.valueOf(NexusRedirectStrategy.class.getName()) + "#retrieveItem";
    private static final Logger log = LoggerFactory.getLogger(NexusRedirectStrategy.class);

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        if (super.isRedirected(request, response, context)) {
            Header locationHeader = response.getFirstHeader("Location");
            if (locationHeader == null) {
                throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location present");
            }
            URI sourceUri = ((HttpUriRequest)request).getURI();
            String sourceScheme = NexusRedirectStrategy.schemeOf(sourceUri);
            String sourceHost = NexusRedirectStrategy.hostOf(sourceUri);
            URI targetUri = this.createLocationURI(locationHeader.getValue());
            String targetScheme = NexusRedirectStrategy.schemeOf(targetUri);
            String targetHost = NexusRedirectStrategy.hostOf(targetUri);
            if (!Objects.equals(sourceScheme, targetScheme)) {
                if ("http".equals(targetScheme)) {
                    log.debug("Downgrade from HTTPS to HTTP during redirection {} -> {}", (Object)sourceUri, (Object)targetUri);
                } else if ("https".equals(targetScheme) && Objects.equals(sourceHost, targetHost)) {
                    log.debug("Protocol upgrade during redirection on same host {} -> {}", (Object)sourceUri, (Object)targetUri);
                }
            }
            if (Boolean.TRUE == context.getAttribute(CONTENT_RETRIEVAL_MARKER_KEY) && targetUri.getPath().endsWith("/")) {
                log.debug("Not following redirection to index {} -> {}", (Object)sourceUri, (Object)targetUri);
                return false;
            }
            log.debug("Following redirection {} -> {}", (Object)sourceUri, (Object)targetUri);
            return true;
        }
        return false;
    }

    @Nullable
    private static String schemeOf(URI uri) {
        String scheme;
        if (uri != null && (scheme = uri.getScheme()) != null) {
            return scheme.toLowerCase(Locale.US);
        }
        return null;
    }

    @Nullable
    private static String hostOf(URI uri) {
        if (uri != null) {
            return uri.getHost();
        }
        return null;
    }
}

