/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.rutauth.internal.RutAuthAuthenticationToken;
import org.sonatype.nexus.security.authc.HttpHeaderAuthenticationToken;
import org.sonatype.nexus.security.authc.HttpHeaderAuthenticationTokenFactorySupport;
import org.sonatype.nexus.security.realm.RealmManager;

@Named
@Singleton
public class RutAuthAuthenticationTokenFactory
extends HttpHeaderAuthenticationTokenFactorySupport {
    private final RealmManager realmManager;
    private String headerName;

    @Inject
    public RutAuthAuthenticationTokenFactory(RealmManager realmManager) {
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
    }

    protected List<String> getHttpHeaderNames() {
        if (this.headerName != null) {
            return Lists.newArrayList((Object[])new String[]{this.headerName});
        }
        return Collections.emptyList();
    }

    protected HttpHeaderAuthenticationToken createToken(String headerName, String headerValue, String host) {
        return new RutAuthAuthenticationToken(headerName, headerValue, host);
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
        this.maybeConfigureRealm();
    }

    private void maybeConfigureRealm() {
        this.realmManager.enableRealm("rutauth-realm");
    }
}

