/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.rutauth.internal.RutAuthAuthenticationTokenFactory;
import org.sonatype.nexus.rutauth.internal.RutAuthCapabilityConfiguration;

@Named(value="rutauth")
public class RutAuthCapability
extends CapabilitySupport<RutAuthCapabilityConfiguration> {
    private final RutAuthAuthenticationTokenFactory authenticationTokenFactory;

    @Inject
    public RutAuthCapability(RutAuthAuthenticationTokenFactory authenticationTokenFactory) {
        this.authenticationTokenFactory = (RutAuthAuthenticationTokenFactory)((Object)Preconditions.checkNotNull((Object)((Object)authenticationTokenFactory), (Object)"authenticationTokenFactory"));
    }

    protected RutAuthCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new RutAuthCapabilityConfiguration(properties);
    }

    protected void onActivate(RutAuthCapabilityConfiguration config) throws Exception {
        this.authenticationTokenFactory.setHeaderName(config.getHttpHeader());
    }

    protected void onPassivate(RutAuthCapabilityConfiguration config) throws Exception {
        this.authenticationTokenFactory.setHeaderName(null);
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().passivateCapabilityDuringUpdate();
    }
}

