/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.rutauth.internal.RutAuthCapabilityConfiguration;

@Named(value="rutauth")
@Singleton
public class RutAuthCapabilityDescriptor
extends CapabilityDescriptorSupport<RutAuthCapabilityConfiguration>
implements Taggable {
    public static final String TYPE_ID = "rutauth";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"rutauth");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new StringTextFormField("httpHeader", messages.httpHeaderLabel(), messages.httpHeaderHelp(), true)});

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected RutAuthCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new RutAuthCapabilityConfiguration(properties);
    }

    protected String renderAbout() throws Exception {
        return this.render("rutauth-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Security")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Rut Auth")
        public String name();

        @MessageBundle.DefaultMessage(value="HTTP Header name")
        public String httpHeaderLabel();

        @MessageBundle.DefaultMessage(value="Handled HTTP Header should contain the name of the header that is used to source the principal of already authenticated user.")
        public String httpHeaderHelp();
    }
}

