/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.karaf;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.karaf.main.Main;
import org.osgi.framework.Version;

public class NexusMain
extends Main {
    static final Version MINIMUM_JAVA_VERSION = new Version(1, 8, 0);
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public NexusMain(String[] args) {
        super(args);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.util.logging.manager", "org.sonatype.nexus.karaf.NonResettableLogManager");
        while (true) {
            boolean restart = false;
            System.setProperty("karaf.restart", "false");
            NexusMain main = new NexusMain(args);
            try {
                main.launch();
            }
            catch (Throwable ex) {
                System.err.println(ex.getMessage());
                main.log.log(Level.SEVERE, "Could not launch framework", ex);
                main.destroy();
                main.setExitCode(-1);
            }
            try {
                try {
                    main.awaitShutdown();
                    boolean stopped = main.destroy();
                    restart = Boolean.getBoolean("karaf.restart");
                    main.updateInstancePidAfterShutdown();
                    if (!stopped) {
                        if (restart) {
                            System.err.println("Timeout waiting for framework to stop.  Restarting now.");
                        } else {
                            System.err.println("Timeout waiting for framework to stop.  Exiting VM.");
                            main.setExitCode(-3);
                        }
                    }
                }
                catch (Throwable ex) {
                    main.setExitCode(-2);
                    System.err.println("Error occurred shutting down framework: " + ex);
                    ex.printStackTrace();
                    if (!restart) {
                        System.exit(main.getExitCode());
                        continue;
                    }
                    System.gc();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (!restart) {
                    System.exit(main.getExitCode());
                } else {
                    System.gc();
                }
                throw throwable;
            }
            if (!restart) {
                System.exit(main.getExitCode());
                continue;
            }
            System.gc();
        }
    }

    public void launch() throws Exception {
        NexusMain.requireMinimumJavaVersion();
        File baseDir = this.getDirectory("karaf.base");
        File dataDir = this.getDirectory("karaf.data");
        NexusMain.setDirectory("karaf.instances", dataDir, "instances");
        NexusMain.setDirectory("karaf.etc", baseDir, "etc/karaf");
        NexusMain.setDirectory("logback.etc", baseDir, "etc/logback");
        this.log.info("Launching Nexus...");
        super.launch();
        this.log.info("...launched Nexus!");
    }

    private IllegalArgumentException badArgument(String format, Object ... args) {
        Object cause;
        String message = String.format(format, args);
        Object object = cause = args.length > 0 ? args[args.length - 1] : null;
        if (cause instanceof Throwable) {
            this.log.log(Level.SEVERE, message, (Throwable)cause);
            return new IllegalArgumentException(message, (Throwable)cause);
        }
        this.log.log(Level.SEVERE, message);
        return new IllegalArgumentException(message);
    }

    private File getDirectory(String propertyName) {
        String path = System.getProperty(propertyName);
        if (path == null || path.trim().isEmpty()) {
            throw this.badArgument("Missing property %s", propertyName);
        }
        try {
            File directory = new File(path).getCanonicalFile();
            if (!directory.isDirectory()) {
                Files.createDirectories(directory.toPath(), new FileAttribute[0]);
            }
            return directory;
        }
        catch (Exception e) {
            throw this.badArgument("No such directory %s (%s)", path, propertyName, e);
        }
    }

    private static void setDirectory(String propertyName, File parent, String child) {
        System.setProperty(propertyName, new File(parent, child).getAbsolutePath());
    }

    static void requireMinimumJavaVersion() {
        if (NexusMain.isNotSupportedVersion(System.getProperty("java.version"))) {
            System.err.println("Nexus requires minimum java.version: " + MINIMUM_JAVA_VERSION);
            if (NexusMain.versionCheckRequired()) {
                System.exit(-1);
            }
        }
    }

    private static boolean isNotSupportedVersion(String currentVersion) {
        try {
            return MINIMUM_JAVA_VERSION.compareTo(new Version(currentVersion.replace('_', '.'))) > 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return true;
        }
    }

    private static boolean versionCheckRequired() {
        return Boolean.parseBoolean(System.getProperty("nexus.vmCheck", "true"));
    }
}

