/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.internal.PropertyMap;

public class ConfigurationBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationBuilder.class);
    private final PropertyMap properties = new PropertyMap();

    public ConfigurationBuilder properties(Map<String, String> props) {
        if (props == null) {
            throw new NullPointerException();
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding properties:");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                log.debug("  {}='{}'", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.properties.putAll(props);
        return this;
    }

    public ConfigurationBuilder properties(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException();
        }
        log.debug("Reading properties from: {}", (Object)url);
        PropertyMap props = new PropertyMap();
        props.load(url);
        return this.properties(props);
    }

    public ConfigurationBuilder properties(String resource, boolean required) throws IOException {
        return this.properties(this.getClass(), resource, required);
    }

    public ConfigurationBuilder properties(Class<?> clazz, String resource, boolean required) throws IOException {
        URL url = clazz.getResource(resource);
        if (url == null) {
            if (required) {
                throw new IllegalStateException("Missing required resource: " + resource);
            }
            return this;
        }
        return this.properties(url);
    }

    public ConfigurationBuilder properties(File resource, boolean required) throws IOException {
        if (resource == null || !resource.exists()) {
            if (required) {
                throw new IllegalStateException("Missing required resource: " + resource);
            }
            return this;
        }
        return this.properties(resource.toURI().toURL());
    }

    public ConfigurationBuilder properties(File resource, String onlyConcern, boolean required) throws IOException {
        if (resource == null || !resource.exists()) {
            if (required) {
                throw new IllegalStateException("Missing required resource: " + resource);
            }
            return this;
        }
        URL url = resource.toURI().toURL();
        log.debug("Reading properties from: {}", (Object)url);
        PropertyMap props = new PropertyMap();
        props.load(url);
        PropertyMap trimmed = new PropertyMap();
        if (props.containsKey(onlyConcern)) {
            trimmed.put(onlyConcern, (String)props.get(onlyConcern));
        }
        return this.properties(trimmed);
    }

    public ConfigurationBuilder defaults() throws IOException {
        return this.properties("default.properties", true);
    }

    public ConfigurationBuilder set(String name, String value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        log.debug("Set: {}={}", (Object)name, (Object)value);
        this.properties.put(name, value);
        return this;
    }

    public ConfigurationBuilder custom(Customizer customizer) throws Exception {
        if (customizer == null) {
            throw new NullPointerException();
        }
        log.debug("Customizing: {}", (Object)customizer);
        customizer.apply(this);
        return this;
    }

    public ConfigurationBuilder override(Map<String, String> overrides) {
        if (overrides == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            String name = entry.getKey();
            if (!this.properties.containsKey(name)) continue;
            String value = entry.getValue();
            log.debug("Override: {}={}", (Object)name, (Object)value);
            this.properties.put(name, value);
        }
        return this;
    }

    public ConfigurationBuilder override(Properties overrides) {
        return this.override(new PropertyMap(overrides));
    }

    private void canonicalize(String name) throws IOException {
        String value = (String)this.properties.get(name);
        if (value == null) {
            log.warn("Unable to canonicalize null entry: {}", (Object)name);
            return;
        }
        File file = new File(value).getCanonicalFile();
        this.properties.put(name, file.getPath());
    }

    private void interpolate() throws Exception {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)this.properties));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
        interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        for (Map.Entry entry : this.properties.entrySet()) {
            this.properties.put((String)entry.getKey(), interpolator.interpolate((String)entry.getValue()));
        }
    }

    public Map<String, String> build() throws Exception {
        if (this.properties.isEmpty()) {
            throw new IllegalStateException("Not configured");
        }
        this.interpolate();
        this.canonicalize("karaf.base");
        this.canonicalize("karaf.etc");
        this.canonicalize("karaf.data");
        PropertyMap props = new PropertyMap(this.properties);
        log.info("Properties:");
        for (String key : props.keys()) {
            log.info("  {}='{}'", (Object)key, props.get(key));
        }
        return props;
    }

    public static interface Customizer {
        public void apply(ConfigurationBuilder var1) throws Exception;
    }
}

