/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertyMap
extends HashMap<String, String> {
    public PropertyMap() {
    }

    public PropertyMap(Map<String, String> map) {
        super(map);
    }

    public PropertyMap(Properties properties) {
        this.putAll(properties);
    }

    public void putAll(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.put(entry.getKey().toString(), String.valueOf(entry.getValue()));
        }
    }

    public String get(String key, String defaultValue) {
        String value = (String)super.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void load(InputStream input) throws IOException {
        Properties p = new Properties();
        p.load(input);
        this.putAll(p);
    }

    public void load(URL url) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = url.openStream();){
            this.load(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<String> keys() {
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        return Collections.unmodifiableList(keys);
    }
}

