/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.jetty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.bootstrap.jetty.ConnectorConfiguration;
import org.sonatype.nexus.bootstrap.jetty.InstrumentedConnectionFactory;
import org.sonatype.nexus.bootstrap.jetty.UnsupportedHttpSchemeException;

public class ConnectorManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectorManager.class);
    private static final String HTTP_CONFIG_ID = "httpConfig";
    private static final String HTTP_CONNECTOR_ID = "httpConnector";
    private static final String SSL_CONTEXT_FACTORY_ID = "sslContextFactory";
    private static final String HTTPS_CONFIG_ID = "httpsConfig";
    private static final String HTTPS_CONNECTOR_ID = "httpsConnector";
    private final Server server;
    private final Map<String, Object> namedBeans;
    private final IdentityHashMap<ConnectorConfiguration, ServerConnector> managedConnectors;
    private final List<ConnectorConfiguration> defaultConnectors;

    public ConnectorManager(Server server, Map<String, Object> namedBeans) {
        this.server = server;
        this.namedBeans = namedBeans;
        this.managedConnectors = new IdentityHashMap();
        this.defaultConnectors = Collections.unmodifiableList(this.buildDefaultConnectors());
    }

    public List<ConnectorConfiguration> defaultConnectors() {
        return this.defaultConnectors;
    }

    public ServerConnector addConnector(ConnectorConfiguration connectorConfiguration) {
        ServerConnector serverConnector;
        HttpScheme httpScheme = connectorConfiguration.getScheme();
        this.verifyConfiguration(httpScheme);
        HttpConfiguration httpConfiguration = connectorConfiguration.customize(this.defaultHttpConfiguration(httpScheme));
        ServerConnector connectorPrototype = this.defaultConnector(httpScheme);
        if (HttpScheme.HTTP == httpScheme) {
            serverConnector = new ServerConnector(this.server, connectorPrototype.getAcceptors(), connectorPrototype.getSelectorManager().getSelectorCount(), new ConnectionFactory[]{new InstrumentedConnectionFactory((ConnectionFactory)new HttpConnectionFactory(httpConfiguration))});
        } else if (HttpScheme.HTTPS == httpScheme) {
            SslContextFactory sslContextFactory = this.bean(SSL_CONTEXT_FACTORY_ID, SslContextFactory.class);
            serverConnector = new ServerConnector(this.server, connectorPrototype.getAcceptors(), connectorPrototype.getSelectorManager().getSelectorCount(), new ConnectionFactory[]{new InstrumentedConnectionFactory((ConnectionFactory)new SslConnectionFactory(sslContextFactory, "http/1.1")), new HttpConnectionFactory(httpConfiguration)});
        } else {
            throw new UnsupportedHttpSchemeException(httpScheme);
        }
        serverConnector.setHost(connectorPrototype.getHost());
        serverConnector.setPort(connectorConfiguration.getPort());
        serverConnector.setIdleTimeout(connectorPrototype.getIdleTimeout());
        serverConnector.setSoLingerTime(connectorPrototype.getSoLingerTime());
        serverConnector.setAcceptorPriorityDelta(connectorPrototype.getAcceptorPriorityDelta());
        serverConnector.setAcceptQueueSize(connectorPrototype.getAcceptQueueSize());
        this.managedConnectors.put(connectorConfiguration, serverConnector);
        this.server.addConnector((Connector)serverConnector);
        try {
            serverConnector.start();
        }
        catch (Exception e) {
            log.warn("Could not start connector: {}", (Object)connectorConfiguration, (Object)e);
            throw new RuntimeException(e);
        }
        return serverConnector;
    }

    public void removeConnector(ConnectorConfiguration connectorConfiguration) {
        ServerConnector serverConnector = this.managedConnectors.remove(connectorConfiguration);
        if (serverConnector != null) {
            try {
                serverConnector.stop();
            }
            catch (Exception e) {
                log.warn("Could not stop connector: {}", (Object)connectorConfiguration, (Object)e);
                throw new RuntimeException(e);
            }
            this.server.removeConnector((Connector)serverConnector);
        }
    }

    private void verifyConfiguration(HttpScheme httpScheme) {
        block4: {
            try {
                if (HttpScheme.HTTP == httpScheme) {
                    this.bean(HTTP_CONFIG_ID, HttpConfiguration.class);
                    this.bean(HTTP_CONNECTOR_ID, ServerConnector.class);
                    break block4;
                }
                if (HttpScheme.HTTPS == httpScheme) {
                    this.bean(SSL_CONTEXT_FACTORY_ID, SslContextFactory.class);
                    this.bean(HTTPS_CONFIG_ID, HttpConfiguration.class);
                    this.bean(HTTPS_CONNECTOR_ID, ServerConnector.class);
                    break block4;
                }
                throw new UnsupportedHttpSchemeException(httpScheme);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Jetty HTTPS is not enabled in Nexus", e);
            }
        }
    }

    private List<ConnectorConfiguration> buildDefaultConnectors() {
        int port;
        ArrayList<ConnectorConfiguration> result = new ArrayList<ConnectorConfiguration>();
        try {
            this.verifyConfiguration(HttpScheme.HTTP);
            port = this.defaultConnector(HttpScheme.HTTP).getPort();
            result.add(new ConnectorConfiguration(){

                @Override
                public HttpScheme getScheme() {
                    return HttpScheme.HTTP;
                }

                @Override
                public int getPort() {
                    return port;
                }

                @Override
                public HttpConfiguration customize(HttpConfiguration configuration) {
                    return configuration;
                }
            });
        }
        catch (IllegalStateException e) {
            log.debug("No HTTP configuration present", (Throwable)e);
        }
        try {
            this.verifyConfiguration(HttpScheme.HTTPS);
            port = this.defaultConnector(HttpScheme.HTTPS).getPort();
            result.add(new ConnectorConfiguration(){

                @Override
                public HttpScheme getScheme() {
                    return HttpScheme.HTTPS;
                }

                @Override
                public int getPort() {
                    return port;
                }

                @Override
                public HttpConfiguration customize(HttpConfiguration configuration) {
                    return configuration;
                }
            });
        }
        catch (IllegalStateException e) {
            log.debug("No HTTPS configuration present", (Throwable)e);
        }
        return result;
    }

    private HttpConfiguration defaultHttpConfiguration(HttpScheme httpScheme) {
        if (HttpScheme.HTTP == httpScheme) {
            return this.bean(HTTP_CONFIG_ID, HttpConfiguration.class);
        }
        if (HttpScheme.HTTPS == httpScheme) {
            return this.bean(HTTPS_CONFIG_ID, HttpConfiguration.class);
        }
        throw new UnsupportedHttpSchemeException(httpScheme);
    }

    private ServerConnector defaultConnector(HttpScheme httpScheme) {
        if (HttpScheme.HTTP == httpScheme) {
            return this.bean(HTTP_CONNECTOR_ID, ServerConnector.class);
        }
        if (HttpScheme.HTTPS == httpScheme) {
            return this.bean(HTTPS_CONNECTOR_ID, ServerConnector.class);
        }
        throw new UnsupportedHttpSchemeException(httpScheme);
    }

    private <T> T bean(String name, Class<T> clazz) {
        Object bean = this.namedBeans.get(name);
        if (bean == null) {
            throw new IllegalStateException("Jetty XML configuration does not contain bean with name: " + name + ", type=" + clazz.getName());
        }
        return clazz.cast(bean);
    }
}

