/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.bootstrap.osgi;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public final class DelegatingFilter
implements Filter {
    private static FilterConfig cachedConfig;
    private static volatile Filter delegate;

    public static synchronized void set(Filter filter) {
        if (cachedConfig != null) {
            try {
                filter.init(cachedConfig);
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        }
        delegate = filter;
    }

    public static synchronized void unset(Filter filter) {
        if (delegate == filter) {
            delegate = null;
        }
        if (cachedConfig != null) {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        Class<DelegatingFilter> clazz = DelegatingFilter.class;
        synchronized (DelegatingFilter.class) {
            cachedConfig = filterConfig;
            if (delegate != null) {
                delegate.init(filterConfig);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Filter filter = delegate;
        if (filter != null) {
            filter.doFilter(request, response, chain);
        } else if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setStatus(503);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Class<DelegatingFilter> clazz = DelegatingFilter.class;
        synchronized (DelegatingFilter.class) {
            cachedConfig = null;
            if (delegate != null) {
                delegate.destroy();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

