/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;

@Named
@Singleton
public class BlobStorePromoter
extends ComponentSupport {
    private final BlobStoreManager blobStoreManager;

    @Inject
    public BlobStorePromoter(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    public BlobStoreGroup promote(BlobStore from) {
        BlobStoreConfiguration fromConf = from.getBlobStoreConfiguration();
        String fromOldName = fromConf.getName();
        String fromNewName = String.format("%s-%s", fromOldName, "promoted");
        BlobStoreConfiguration groupConf = fromConf.copy(fromOldName);
        groupConf.setType("Group");
        groupConf.attributes("group").set("members", Collections.singletonList(fromNewName));
        groupConf.attributes("group").set("fillPolicy", (Object)"writeToFirst");
        fromConf.setName(fromNewName);
        try {
            this.blobStoreManager.forceDelete(fromOldName);
        }
        catch (Exception e) {
            throw new BlobStoreException(String.format("during promotion to group, failed to stop existing blob store: %s", fromOldName), (Throwable)e, null);
        }
        try {
            this.blobStoreManager.create(fromConf);
        }
        catch (Exception e) {
            fromConf.setName(fromOldName);
            try {
                this.blobStoreManager.create(fromConf);
            }
            catch (Exception inner) {
                this.log.error("during promotion to group, existing blob: {} store was removed, but failed to be created with new configuration and failed to be resurrected", (Object)fromOldName, (Object)inner);
            }
            throw new BlobStoreException(String.format("during promotion to group, failed to stop existing blob store: %s", fromOldName), (Throwable)e, null);
        }
        try {
            return (BlobStoreGroup)this.blobStoreManager.create(groupConf);
        }
        catch (Exception e) {
            try {
                this.blobStoreManager.forceDelete(fromNewName);
            }
            catch (Exception inner) {
                this.log.error("during promotion to group, existing blob: {} store was removed, but the creation of the new group failed, recreating the original blob store", (Object)fromOldName, (Object)inner);
            }
            fromConf.setName(fromOldName);
            try {
                this.blobStoreManager.create(fromConf);
            }
            catch (Exception inner) {
                this.log.error("during promotion to group, existing blob: {} store was removed, but failed to be created with new configuration and failed to be resurrected", (Object)fromOldName, (Object)inner);
            }
            throw new BlobStoreException("failed to create group configuration", (Throwable)e, null);
        }
    }
}

