/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.internal.tasks;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupConfigurationHelper;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupService;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskInterruptedException;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class BlobStoreGroupMemberRemovalTask
extends TaskSupport
implements Cancelable {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final ProgressLogIntervalHelper intervalLogger;
    private final BlobStoreManager manager;
    private final ForkJoinPool forkJoinPool;
    private final BlobStoreGroupService blobStoreGroupService;

    @Inject
    public BlobStoreGroupMemberRemovalTask(BlobStoreManager manager, BlobStoreGroupService blobStoreGroupService) {
        this.manager = (BlobStoreManager)Preconditions.checkNotNull((Object)manager);
        this.intervalLogger = new ProgressLogIntervalHelper(this.log, 15);
        this.forkJoinPool = new ForkJoinPool();
        this.blobStoreGroupService = (BlobStoreGroupService)Preconditions.checkNotNull((Object)blobStoreGroupService);
    }

    public String getMessage() {
        return messages.message();
    }

    public Object execute() throws Exception {
        if (!this.blobStoreGroupService.isEnabled()) {
            throw new IllegalStateException("Blob store groups are not enabled");
        }
        String groupName = this.getConfiguration().getString("fromGroup");
        String memberToRemove = this.getConfiguration().getString("memberToRemove");
        BlobStore group = (BlobStore)Preconditions.checkNotNull((Object)this.manager.get(groupName));
        BlobStore src = (BlobStore)Preconditions.checkNotNull((Object)this.manager.get(memberToRemove));
        Preconditions.checkArgument((boolean)(group instanceof BlobStoreGroup), (Object)String.format("'%s' must be a Blob Store Group.", groupName));
        List members = ((BlobStoreGroup)group).getMembers();
        long availableCount = members.stream().filter(blobStore -> !blobStore.getBlobStoreConfiguration().getName().equals(memberToRemove)).filter(BlobStore::isWritable).count();
        Preconditions.checkArgument((availableCount > 0L ? 1 : 0) != 0, (Object)"One or more other blob store member must be available in the group.");
        Preconditions.checkArgument((boolean)members.contains(src), (Object)String.format("'%s' must be a member of group '%s'.", memberToRemove, groupName));
        this.setSourceWritable(src, false);
        long initialBlobCount = src.getMetrics().getBlobCount();
        AtomicLong processed = new AtomicLong(0L);
        Consumer<BlobId> blobIdConsumer = blobId -> {
            this.moveBlob((BlobId)blobId, src, group);
            this.intervalLogger.info("Elapsed time: {}, Total processed {}/{}", new Object[]{this.intervalLogger.getElapsed(), processed.incrementAndGet(), initialBlobCount});
        };
        this.forkJoinPool.submit(() -> ((Stream)src.getBlobIdStream().parallel()).forEach(blobIdConsumer));
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Elapsed time: {}, Total processed {}/{}", new Object[]{this.intervalLogger.getElapsed(), processed, initialBlobCount});
        this.waitForCompletionOfTasks(this.forkJoinPool);
        if (this.isCanceled()) {
            throw new TaskInterruptedException("Task has been interrupted", this.isCanceled());
        }
        this.removeMemberFromGroup(memberToRemove, group);
        this.setSourceWritable(src, true);
        return null;
    }

    private void waitForCompletionOfTasks(ForkJoinPool forkJoinPool) {
        try {
            forkJoinPool.shutdown();
            forkJoinPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new TaskInterruptedException("Task has been interrupted", false);
        }
    }

    private void setSourceWritable(BlobStore src, boolean writable) throws Exception {
        BlobStoreConfiguration blobStoreConfiguration = src.getBlobStoreConfiguration();
        blobStoreConfiguration.setWritable(writable);
        this.manager.update(blobStoreConfiguration);
    }

    private void removeMemberFromGroup(String memberToRemove, BlobStore group) throws Exception {
        BlobStoreConfiguration groupConfig = group.getBlobStoreConfiguration();
        List memberNames = BlobStoreGroupConfigurationHelper.memberNames((BlobStoreConfiguration)groupConfig);
        memberNames.remove(memberToRemove);
        groupConfig.attributes("group").set("members", (Object)memberNames);
        this.manager.update(groupConfig);
    }

    private InputStream inputStreamOf(BlobStore blobStore, BlobId blobId) {
        return Optional.of(blobId).map(r -> blobStore.get(r, true)).map(Blob::getInputStream).orElseThrow(() -> new IllegalStateException(String.format("Unable to get input stream from source %S with blobId: %s", blobStore.getBlobStoreConfiguration().getName(), blobId)));
    }

    private void moveBlob(BlobId blobId, BlobStore srcBlobStore, BlobStore destBlobStore) {
        Preconditions.checkNotNull((Object)srcBlobStore);
        Preconditions.checkNotNull((Object)destBlobStore);
        BlobAttributes srcBlobAttributes = srcBlobStore.getBlobAttributes(blobId);
        boolean isSrcDelted = srcBlobAttributes.isDeleted();
        Map headers = srcBlobAttributes.getHeaders();
        InputStream srcInputStream = this.inputStreamOf(srcBlobStore, blobId);
        destBlobStore.create(srcInputStream, headers, blobId);
        destBlobStore.setBlobAttributes(blobId, srcBlobAttributes);
        this.ensureDeletedStateTransferred(blobId, srcBlobStore, destBlobStore, isSrcDelted);
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Created blobId {} in blob store '{}'", (Object)blobId, (Object)destBlobStore.getBlobStoreConfiguration().getName());
        try {
            srcBlobStore.deleteHard(blobId);
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Removed blobId {} from blob store '{}'", (Object)blobId, (Object)srcBlobStore.getBlobStoreConfiguration().getName());
        }
        catch (BlobStoreException e) {
            this.log.warn(TaskLoggingMarkers.TASK_LOG_ONLY, "Failed to remove blobId {} from blob store '{}'", new Object[]{blobId, srcBlobStore.getBlobStoreConfiguration().getName(), e});
        }
    }

    private void ensureDeletedStateTransferred(BlobId blobId, BlobStore srcBlobStore, BlobStore destBlobStore, boolean isSrcDeleted) {
        BlobAttributes currentSrcAttributes = srcBlobStore.getBlobAttributes(blobId);
        if (currentSrcAttributes != null && currentSrcAttributes.isDeleted() != isSrcDeleted) {
            BlobAttributes outOfDateAttributes = destBlobStore.getBlobAttributes(blobId);
            outOfDateAttributes.setDeleted(!isSrcDeleted);
            destBlobStore.setBlobAttributes(blobId, outOfDateAttributes);
        }
    }

    public void cancel() {
        super.cancel();
        this.forkJoinPool.shutdownNow();
        BlobStore member = Optional.of(this.getConfiguration()).map(c -> c.getString("memberToRemove")).map(arg_0 -> ((BlobStoreManager)this.manager).get(arg_0)).orElseThrow(() -> new IllegalStateException("Unable to find member to be removed"));
        try {
            this.setSourceWritable(member, true);
        }
        catch (Exception e) {
            this.log.error("Failed to clear read only attribute on blob store '{}' when job was cancelled", (Object)member.getBlobStoreConfiguration().getName(), (Object)e);
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Run blob store group member removal task")
        public String message();
    }
}

