/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.storage.BrowseNode;
import org.sonatype.nexus.repository.storage.BrowseNodeFilter;

@Singleton
@Named(value="yum")
public class YumBrowseNodeFilter
implements BrowseNodeFilter {
    public boolean test(BrowseNode node, String repositoryName) {
        if (node.getAssetNameLowercase() == null) {
            return true;
        }
        if (StringUtils.equals((CharSequence)node.getRepositoryName(), (CharSequence)repositoryName)) {
            return true;
        }
        boolean isMetadata = "/repodata/".equalsIgnoreCase(node.getParentPath()) && node.getAssetNameLowercase().contains(".xml");
        return !isMetadata;
    }
}

