/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.YumFacet;
import org.sonatype.nexus.repository.yum.internal.YumAssetAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.YumComponentAttributePopulator;
import org.sonatype.nexus.repository.yum.internal.createrepo.RpmRedeployedEvent;
import org.sonatype.nexus.repository.yum.internal.database.YumQueryComponent;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumFacetUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class YumFacetImpl
extends FacetSupport
implements YumFacet {
    private YumRpmParser rpmParser;
    private YumComponentAttributePopulator yumComponentAttributePopulator;
    private YumAssetAttributePopulator yumAssetAttributePopulator;
    private final YumQueryComponent yumQueryComponent;

    @Inject
    public YumFacetImpl(YumRpmParser yumRpmParser, YumComponentAttributePopulator yumComponentAttributePopulator, YumAssetAttributePopulator yumAssetAttributePopulator, YumQueryComponent yumQueryComponent) {
        this.rpmParser = (YumRpmParser)((Object)Preconditions.checkNotNull((Object)((Object)yumRpmParser)));
        this.yumComponentAttributePopulator = (YumComponentAttributePopulator)((Object)Preconditions.checkNotNull((Object)((Object)yumComponentAttributePopulator)));
        this.yumAssetAttributePopulator = (YumAssetAttributePopulator)((Object)Preconditions.checkNotNull((Object)((Object)yumAssetAttributePopulator)));
        this.yumQueryComponent = (YumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryComponent)));
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getAssetAsContent(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.doGetAsset(name, tx);
        if (asset == null) {
            return null;
        }
        return YumFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Nullable
    private Asset doGetAsset(String name, StorageTx tx) {
        Asset asset = this.yumQueryComponent.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return asset;
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Asset getAsset(String name) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return this.doGetAsset(name, tx);
    }

    @Override
    public Content storeMetadata(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind) throws IOException {
        return this.storeMetadata(assetPath, metadataContent, payload, assetKind, new AttributesMap());
    }

    @Override
    @TransactionalStoreBlob
    public Content storeMetadata(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind, AttributesMap attributesMap) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.findOrCreateAsset(assetPath, assetKind, attributesMap, tx, bucket);
        return this.saveAsset(tx, asset, (Supplier<InputStream>)metadataContent, payload);
    }

    @Override
    @TransactionalStoreBlob
    public Asset storeMetadata(String assetPath, AssetBlob assetBlob, AssetKind assetKind, AttributesMap contentAttributes) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.findOrCreateAsset(assetPath, assetKind, contentAttributes, tx, bucket);
        this.saveAsset(tx, asset, assetBlob, assetKind, contentAttributes);
        return asset;
    }

    @Override
    @TransactionalStoreBlob
    public Content storeRpm(String assetPath, Supplier<InputStream> rpmContent, Payload payload) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        boolean isRpmRedeploy = this.yumQueryComponent.findAsset(tx, bucket = tx.findBucket(this.getRepository()), assetPath) != null;
        Asset asset = this.createRpmAsset(assetPath, tx, bucket, (InputStream)rpmContent.get());
        Content content = this.saveAsset(tx, asset, rpmContent, payload);
        if (isRpmRedeploy) {
            this.getEventManager().post((Object)new RpmRedeployedEvent(asset.getEntityMetadata(), this.getRepository().getName(), asset.componentId()));
        }
        return content;
    }

    @Override
    @TransactionalStoreBlob
    public Asset storeRpm(String assetPath, AssetBlob assetBlob, AttributesMap contentAttributes) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.createRpmAsset(assetPath, tx, bucket, assetBlob.getBlob().getInputStream());
        this.saveAsset(tx, asset, assetBlob, AssetKind.RPM, contentAttributes);
        return asset;
    }

    private Asset createRpmAsset(String assetPath, StorageTx tx, Bucket bucket, InputStream inputStream) throws IOException {
        YumRpm rpm;
        Throwable throwable = null;
        Object var7_7 = null;
        try (InputStream in = inputStream;){
            rpm = this.rpmParser.parse(in, assetPath);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.findOrCreateAssetAndComponent(assetPath, tx, bucket, rpm);
    }

    @Override
    public Asset findOrCreateAsset(String assetPath, AssetKind assetKind, AttributesMap attributesMap, StorageTx tx, Bucket bucket) {
        Asset asset = this.yumQueryComponent.findAsset(tx, bucket, assetPath);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
            for (Map.Entry entry : attributesMap) {
                asset.formatAttributes().set((String)entry.getKey(), entry.getValue());
            }
        }
        return asset;
    }

    private Asset findOrCreateAssetAndComponent(String assetPath, StorageTx tx, Bucket bucket, YumRpm rpm) {
        Asset asset = this.yumQueryComponent.findAsset(tx, bucket, assetPath);
        if (asset == null) {
            Component component = this.findOrCreateComponent(tx, bucket, rpm);
            asset = tx.createAsset(bucket, component);
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.RPM.name());
        }
        this.yumAssetAttributePopulator.populate(asset.formatAttributes(), rpm);
        return asset;
    }

    private Component findOrCreateComponent(StorageTx tx, Bucket bucket, YumRpm rpm) {
        Component component = this.yumQueryComponent.findComponent(tx, this.getRepository(), rpm.getName(), rpm.getFullVersion());
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(rpm.getName())).version(rpm.getFullVersion());
            this.yumComponentAttributePopulator.populate(component.formatAttributes(), rpm);
            tx.saveComponent(component);
        }
        return component;
    }

    private void saveAsset(StorageTx tx, Asset asset, AssetBlob assetBlob, AssetKind kind, AttributesMap contentAttributes) {
        asset.formatAttributes().set("asset_kind", (Object)kind.name());
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        tx.saveAsset(asset);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, Supplier<InputStream> contentSupplier, Payload payload) throws IOException {
        AttributesMap contentAttributes = new AttributesMap();
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return this.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes);
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, Supplier<InputStream> contentSupplier, String contentType, AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, YumFacetUtils.HASH_ALGORITHMS, null, contentType, false);
        tx.saveAsset(asset);
        return YumFacetUtils.toContent(asset, assetBlob.getBlob());
    }
}

