/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoService;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.RpmRedeployedEvent;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataInvalidationEvent;
import org.sonatype.nexus.repository.yum.internal.hosted.YumHostedFacet;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class CreateRepoFacetImpl
extends FacetSupport
implements CreateRepoFacet,
EventAware.Asynchronous {
    private final CreateRepoService createRepo;
    private final EventManager eventManager;
    private final long interval;
    private final AtomicBoolean acceptingEvents = new AtomicBoolean(true);
    private final AtomicBoolean eventFired = new AtomicBoolean(false);
    private final boolean cachingEnabled;
    @VisibleForTesting
    Clock clock = new Clock();

    @Inject
    public CreateRepoFacetImpl(CreateRepoService createRepo, EventManager eventManager, @Named(value="${nexus.yum.createrepo.interval:-60000}") long interval, @Named(value="${nexus.yum.createrepo.caching:-true}") boolean cachingEnabled) {
        this.createRepo = (CreateRepoService)Preconditions.checkNotNull((Object)createRepo);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.interval = interval;
        this.cachingEnabled = cachingEnabled;
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent deleted) {
        if (this.matchesRepository((AssetEvent)deleted) && this.isEventRelevant((AssetEvent)deleted)) {
            this.invalidateMetadata();
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent created) {
        if (this.matchesRepository((AssetEvent)created) && this.isEventRelevant((AssetEvent)created)) {
            this.invalidateMetadata();
        }
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(RpmRedeployedEvent updated) {
        if (this.matchesRepository(updated) && this.isEventRelevant(updated) && this.hasBlobBeenUpdated(updated)) {
            this.invalidateMetadata();
        }
    }

    @Override
    public synchronized void invalidateMetadata() {
        if (this.acceptingEvents.get() && !this.eventFired.get()) {
            this.log.info("Scheduling rebuild of yum metadata to start in {} seconds", (Object)(this.interval / 1000L));
            this.eventFired.set(true);
            this.eventManager.post((Object)new YumMetadataInvalidationEvent(this.getRepository().getName(), true, true));
        }
    }

    @Override
    public void invalidateMetadataWithoutWaiting(boolean useCache) {
        this.eventFired.set(true);
        this.eventManager.post((Object)new YumMetadataInvalidationEvent(this.getRepository().getName(), false, useCache));
    }

    @Subscribe
    public void on(YumMetadataInvalidationEvent event) {
        if (this.shouldProcess(event)) {
            this.acceptingEvents.set(false);
            this.maybeWait(event);
            this.log.info("Rebuilding yum metadata for repository {}", (Object)this.getRepository().getName());
            UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
            try {
                this.acceptingEvents.set(true);
                this.eventFired.set(false);
                long startTime = this.clock.millis();
                this.updateMetadata(this.buildMetadata(event));
                ((YumHostedFacet)this.getRepository().facet(YumHostedFacet.class)).metadataGenerationStarted(startTime);
            }
            finally {
                this.log.info("Finished rebuilding yum metadata for repository {}", (Object)this.getRepository().getName());
                UnitOfWork.end();
            }
        }
    }

    private List<MetadataBlob> buildMetadata(YumMetadataInvalidationEvent event) {
        List<MetadataBlob> metadataBlobs = this.cachingEnabled && event.isUseCache() ? this.createRepo.buildMetadataUsingCaching(this.getRepository()) : this.createRepo.buildMetadataWithoutCaching(this.getRepository());
        return metadataBlobs;
    }

    private boolean shouldProcess(YumMetadataInvalidationEvent event) {
        return this.getRepository().getName().equals(event.getRepositoryName());
    }

    private void maybeWait(YumMetadataInvalidationEvent event) {
        if (event.isWaitBeforeRebuild()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("Yum invalidation thread interrupted, proceeding with invalidation");
            }
        }
    }

    @TransactionalStoreBlob
    protected void updateMetadata(List<MetadataBlob> metadataBlobs) {
        YumHostedFacet hosted = (YumHostedFacet)this.getRepository().facet(YumHostedFacet.class);
        String[] excludeFromDelete = (String[])metadataBlobs.stream().map(MetadataBlob::getPath).toArray(String[]::new);
        List<String> directoriesToDelete = metadataBlobs.stream().map(MetadataBlob::getPath).map(path -> YumPathUtils.extractDirectoryFromMetadataPath(path)).filter(path -> !path.isEmpty()).collect(Collectors.toList());
        hosted.deleteAllGeneratedMetadata(directoriesToDelete, excludeFromDelete);
        if (metadataBlobs.isEmpty()) {
            hosted.deleteRepomd();
        }
        this.updateEachMetadataFile(hosted, metadataBlobs);
        this.markDirectoryModified(hosted, metadataBlobs);
    }

    private void updateEachMetadataFile(YumHostedFacet hosted, List<MetadataBlob> metadataBlobs) {
        for (MetadataBlob metadataBlob : metadataBlobs) {
            try {
                try {
                    hosted.putMetadata(metadataBlob.getPath(), metadataBlob.getBlob(), metadataBlob.getContentType(), metadataBlob.getAssetKind());
                }
                catch (IOException e) {
                    this.log.error("Failed to save new metadata", (Throwable)e);
                    metadataBlob.getBlob().close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                metadataBlob.getBlob().close();
                throw throwable;
            }
            metadataBlob.getBlob().close();
        }
    }

    private void markDirectoryModified(YumHostedFacet hosted, List<MetadataBlob> metadataBlobs) {
        HashSet<String> processed = new HashSet<String>();
        int depth = hosted.getRepodataDepth();
        for (MetadataBlob metadataBlob : metadataBlobs) {
            String folder = YumPathUtils.extractDirectoryAtDepth(metadataBlob.getPath(), depth).orElse("");
            if (processed.contains(folder)) continue;
            processed.add(folder);
            hosted.setRpmsRemovedFlagIfCountChanged(folder, metadataBlob.getExpectedRpmCount());
        }
    }

    private boolean matchesRepository(AssetEvent assetEvent) {
        return assetEvent.isLocal() && this.getRepository().getName().equals(assetEvent.getRepositoryName());
    }

    private boolean isEventRelevant(AssetEvent event) {
        return event.getComponentId() != null || AssetKind.COMPS.name().equals(event.getAsset().formatAttributes().get("asset_kind", String.class));
    }

    private boolean hasBlobBeenUpdated(AssetUpdatedEvent updated) {
        DateTime blobUpdated = updated.getAsset().blobUpdated();
        DateTime oneMinuteAgo = DateTime.now().minusMinutes(1);
        return blobUpdated == null || blobUpdated.isAfter((ReadableInstant)oneMinuteAgo);
    }
}

