/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.AbstractMetadataNode;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoService;
import org.sonatype.nexus.repository.yum.internal.createrepo.CreateRepoState;
import org.sonatype.nexus.repository.yum.internal.createrepo.FileListMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataBlob;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.OtherMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.PrimaryMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.RepomdMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumDirectory;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.database.YumQueryComponent;
import org.sonatype.nexus.repository.yum.internal.hosted.YumHostedFacet;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmParser;
import org.sonatype.nexus.repository.yum.internal.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.internal.xmltools.AttributeXmlValueExtractor;
import org.sonatype.nexus.repository.yum.internal.xmltools.ElementXmlValueExtractor;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class CreateRepoServiceImpl
extends ComponentSupport
implements CreateRepoService {
    private static final String PACKAGE = "package";
    private static final String LOCATION = "location";
    private static final String LOCATION_ATTRIBUTE = "href";
    private static final String CHECKSUM = "checksum";
    private final YumRpmParser rpmParser;
    private final YumQueryComponent yumQueryComponent;
    @VisibleForTesting
    Clock clock = new Clock();

    @Inject
    public CreateRepoServiceImpl(YumRpmParser rpmParser, YumQueryComponent yumQueryComponent) {
        this.rpmParser = (YumRpmParser)((Object)Preconditions.checkNotNull((Object)((Object)rpmParser)));
        this.yumQueryComponent = (YumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryComponent)));
    }

    @Override
    @TransactionalTouchBlob
    public List<MetadataBlob> buildMetadataUsingCaching(Repository repository) {
        return this.buildMetadata(repository, true);
    }

    @Override
    @TransactionalTouchBlob
    public List<MetadataBlob> buildMetadataWithoutCaching(Repository repository) {
        return this.buildMetadata(repository, false);
    }

    private List<MetadataBlob> buildMetadata(Repository repository, boolean useCache) {
        try {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Integer repodataDepth = ((YumHostedFacet)repository.facet(YumHostedFacet.class)).getRepodataDepth();
            return this.buildMetadata(new CreateRepoState.CreateRepoStateBuilder().withTx(tx).withRepository(repository).withRepodataDepth(repodataDepth).withUseCache(useCache).build());
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private List<MetadataBlob> buildMetadata(CreateRepoState state) throws IOException, XMLStreamException {
        this.calculateDirectories(state);
        try {
            List<MetadataBlob> list = this.convertDirectoriesToMetadata(state);
            return list;
        }
        finally {
            this.deleteTempFiles(state);
        }
    }

    private void deleteTempFiles(CreateRepoState state) {
        this.log.debug("Removing temp files used in Yum metadata generation");
        for (YumDirectory directory : state.getDirectories()) {
            for (YumMetadataFile file : directory.getFiles()) {
                try {
                    this.log.debug("Removing temporary Yum metadata file {}", (Object)file.getPath());
                    Files.delete(file.getPath());
                }
                catch (IOException e) {
                    this.log.error("Failed to delete temporary file {} during yum metadata creation", (Object)file.getPath(), (Object)e);
                }
            }
        }
    }

    private List<MetadataBlob> convertDirectoriesToMetadata(CreateRepoState state) throws IOException, XMLStreamException {
        ArrayList<MetadataBlob> blobs = new ArrayList<MetadataBlob>();
        for (YumDirectory directory : state.getDirectories()) {
            this.createWriters(state, directory);
            this.writeMetadata(state, directory);
            HashMap<YumMetadataType, YumMetadata> metadataDetails = new HashMap<YumMetadataType, YumMetadata>();
            this.writeRepomd(directory, state, metadataDetails);
            blobs.addAll(this.convertToTempBlobs(state, directory, metadataDetails));
        }
        return blobs;
    }

    private void createWriters(CreateRepoState state, YumDirectory directory) throws IOException, XMLStreamException {
        for (YumMetadataFile file : directory.getFiles()) {
            MetadataWriter<YumRpm> writer;
            if (file.getType() == YumMetadataType.REPOMD || (writer = this.buildWriter(file)) == null) continue;
            state.putWriter(file.getType(), writer);
        }
    }

    @Nullable
    private MetadataWriter<YumRpm> buildWriter(YumMetadataFile file) throws IOException, XMLStreamException {
        switch (file.getType()) {
            case FILELISTS: {
                return new FileListMetadataWriter(this.out(file.getPath()));
            }
            case PRIMARY: {
                return new PrimaryMetadataWriter(this.out(file.getPath()));
            }
            case OTHER: {
                return new OtherMetadataWriter(this.out(file.getPath()));
            }
        }
        return null;
    }

    private void calculateDirectories(CreateRepoState state) throws IOException {
        this.log.debug("Calculating directories for generating Yum metadata for repository {}", (Object)state.getRepository().getName());
        Integer repodataDepth = ((YumHostedFacet)state.getRepository().facet(YumHostedFacet.class)).getRepodataDepth();
        long rpmCount = this.yumQueryComponent.countRpms(state.getTx(), state.getRepository());
        if (rpmCount == 0L) {
            return;
        }
        if (repodataDepth == 0) {
            YumDirectory directory = new YumDirectory("");
            directory.setRpmCount(rpmCount);
            directory.setUseCache(this.useCachedMetadata(state));
            directory.setRpmsRemoved(this.haveRpmsBeenRemovedFromRoot(state));
            this.addFilesToDirectory(directory);
            state.addDirectory(directory);
        } else {
            this.deriveDirectoriesFromRpms(state);
        }
    }

    private boolean haveRpmsBeenRemovedFromRoot(CreateRepoState state) {
        Iterable<Asset> repomd = this.yumQueryComponent.findRepomd(state.getTx(), state.getRepository());
        Iterator<Asset> iterator = repomd.iterator();
        if (iterator.hasNext()) {
            Asset repomdAsset = iterator.next();
            Boolean rpmsRemoved = (Boolean)repomdAsset.formatAttributes().get("rpms_removed", Boolean.class);
            return BooleanUtils.isTrue((Boolean)rpmsRemoved);
        }
        return false;
    }

    private void deriveDirectoriesFromRpms(CreateRepoState state) throws IOException {
        HashMap<String, YumDirectory> directories = new HashMap<String, YumDirectory>();
        this.calculateDirectoriesWithModifiedRpms(state, directories);
        this.calculateDirectoriesWithRemovedRpms(state, directories);
        for (YumDirectory directory : directories.values()) {
            this.addFilesToDirectory(directory);
            state.addDirectory(directory);
        }
    }

    private void calculateDirectoriesWithRemovedRpms(CreateRepoState state, Map<String, YumDirectory> directories) {
        for (String removedRpmPath : this.yumQueryComponent.getMetadataPathsThatHaveHadRpmsRemoved(state.getTx(), state.getRepository())) {
            YumDirectory directory = this.deriveDirectoryForPath(state, directories, removedRpmPath);
            if (directory == null) continue;
            directory.setRpmsRemoved(true);
        }
    }

    private void calculateDirectoriesWithModifiedRpms(CreateRepoState state, Map<String, YumDirectory> directories) {
        Iterable rpms = Iterables.transform(this.browseRpmsForDirectoryCalculation(state), AbstractMetadataNode::name);
        for (String rpm : rpms) {
            this.deriveDirectoryForPath(state, directories, rpm);
        }
    }

    @Nullable
    private YumDirectory deriveDirectoryForPath(CreateRepoState state, Map<String, YumDirectory> directories, String rpm) {
        Optional<String> directoryName = YumPathUtils.extractDirectoryAtDepth(rpm, state.getRepodataDepth());
        if (directoryName.isPresent()) {
            YumDirectory directory;
            if (!directories.containsKey(directoryName.get())) {
                this.log.debug("Found directory {}", (Object)directoryName.get());
                directory = new YumDirectory(directoryName.get());
                directories.put(directoryName.get(), directory);
                directory.setRpmCount(this.yumQueryComponent.countRpmsInDirectory(directoryName.get(), state.getTx(), state.getRepository()));
            }
            if (this.useCachedMetadata(state, directory = directories.get(directoryName.get()))) {
                directory.setUseCache(true);
            }
            return directory;
        }
        this.log.warn("RPM ({}) found above the repodata depth {} while creating the Yum Metadata for {}. This is likely a result of the repodata depth being changed and this RPM will not be included in the metadata and should be removed from the repository.", new Object[]{rpm, state.getRepodataDepth(), state.getRepository().getName()});
        return null;
    }

    private void addFilesToDirectory(YumDirectory directory) throws IOException {
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.FILELISTS, Files.createTempFile(YumMetadataType.FILELISTS.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.PRIMARY, Files.createTempFile(YumMetadataType.PRIMARY.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.OTHER, Files.createTempFile(YumMetadataType.OTHER.lowerName(), "xml.gz", new FileAttribute[0])));
        directory.getFiles().add(new YumMetadataFile(YumMetadataType.REPOMD, Files.createTempFile(YumMetadataType.REPOMD.lowerName(), "xml", new FileAttribute[0])));
    }

    private void writeRepomd(YumDirectory directory, CreateRepoState state, Map<YumMetadataType, YumMetadata> metadataDetails) throws XMLStreamException, IOException {
        int startTimeInSeconds = (int)(this.clock.millis() / 1000L);
        this.log.debug("Building repomd.xml for repository {} and directory {}", (Object)state.getRepository().getName(), (Object)directory.getName());
        Path repomdXml = directory.getFiles().stream().filter(f -> f.getType() == YumMetadataType.REPOMD).findFirst().get().getPath();
        RepomdMetadataWriter repomdMetadataWriter = new RepomdMetadataWriter(Files.newOutputStream(repomdXml, new OpenOption[0]), startTimeInSeconds);
        repomdMetadataWriter.startMetadata(directory.getFiles().size() - 1);
        this.readMetadataAndAppendToRepomd(directory, metadataDetails, repomdMetadataWriter);
        this.appendComps(state, repomdMetadataWriter, directory);
        repomdMetadataWriter.end();
    }

    private void readMetadataAndAppendToRepomd(YumDirectory directory, Map<YumMetadataType, YumMetadata> metadataDetails, RepomdMetadataWriter repomdMetadataWriter) throws IOException, XMLStreamException {
        for (YumMetadataFile file : directory.getFiles()) {
            if (file.getType() == YumMetadataType.REPOMD) continue;
            this.log.debug("Reading metadata file {} from directory {} to get checksums ", (Object)file.getPath(), (Object)directory.getName());
            YumMetadata metadata = YumMetadataUtils.readCompressedMetadata(file);
            metadataDetails.put(file.getType(), metadata);
            repomdMetadataWriter.append(metadata);
        }
    }

    private void appendComps(CreateRepoState state, RepomdMetadataWriter repomdMetadataWriter, YumDirectory directory) throws IOException, XMLStreamException {
        this.log.debug("Searching for comps.xml to add to metadata for directory {}", (Object)directory.getName());
        String path = Optional.ofNullable(directory.getName()).orElse("");
        for (Asset comp : this.yumQueryComponent.findCompsByPath(path, state.getTx(), state.getRepository())) {
            YumMetadata compsMetadata;
            if (comp.name().contains("xml.gz")) {
                this.log.debug("Found compressed comps.xml: {}", (Object)comp.name());
                compsMetadata = YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(YumMetadataType.COMPS_GZ, Paths.get(comp.name(), new String[0])), state.getTx().requireBlob(comp.requireBlobRef()).getInputStream());
            } else {
                this.log.debug("Found uncompressed comps.xml: {}", (Object)comp.name());
                HashCode checksum = comp.getChecksum(HashAlgorithm.SHA256);
                Long size = comp.size();
                compsMetadata = new YumMetadata(YumMetadataType.COMPS).setChecksum(checksum != null ? checksum.toString() : null).setSize(size != null ? size : 0L);
            }
            this.log.debug("Appending {} to repomd.xml for directory {}", (Object)comp.name(), (Object)directory.getName());
            repomdMetadataWriter.append(compsMetadata);
        }
    }

    private OutputStream out(Path path) throws IOException {
        return new BufferedOutputStream((OutputStream)new GzipCompressorOutputStream(Files.newOutputStream(path, new OpenOption[0])));
    }

    private List<MetadataBlob> convertToTempBlobs(CreateRepoState state, YumDirectory directory, Map<YumMetadataType, YumMetadata> metadataDetails) throws IOException {
        ArrayList<MetadataBlob> metadata = new ArrayList<MetadataBlob>();
        for (YumMetadataFile file : directory.getFiles()) {
            YumMetadataType type = file.getType();
            String path = this.buildPath(directory.getName(), type, metadataDetails.get((Object)type));
            TempBlob blob = this.convertFileToTempBlob(file.getPath(), state.getRepository());
            String contentType = path.contains(".gz") ? "application/x-gzip" : "application/xml";
            metadata.add(new MetadataBlob(blob, path, contentType, type.getKind(), directory.getRpmCount()));
        }
        return metadata;
    }

    private String buildPath(String directoryName, YumMetadataType type, @Nullable YumMetadata yumMetadata) {
        String metadataName;
        if (type == YumMetadataType.REPOMD) {
            metadataName = "repodata/repomd.xml";
        } else {
            String checksum = yumMetadata != null ? yumMetadata.getChecksum() : "";
            metadataName = YumPathUtils.buildMetadataFilePath(checksum, type.lowerName());
        }
        return !directoryName.isEmpty() ? String.valueOf(directoryName) + "/" + metadataName : metadataName;
    }

    /*
     * Unable to fully structure code
     */
    private void writeMetadata(CreateRepoState state, YumDirectory directory) {
        this.log.debug("Writing non-repomd metadata for repository {} and directory {}", (Object)state.getRepository().getName(), (Object)directory.getName());
        try {
            try {
                for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                    writer.start((int)directory.getRpmCount());
                }
                if (directory.isUseCache()) {
                    this.log.debug("Directory {} is marked as use cache, appending metadata from existing cached files", (Object)directory.getName());
                    newRpms = new HashSet<String>();
                    for (Asset rpm : this.browseNewRpms(state, directory)) {
                        newRpms.add(rpm.name());
                        this.appendRpm(state, directory, rpm);
                    }
                    this.appendCachedEntries(state, directory, newRpms);
                } else {
                    this.loopAllRpmsAndAppend(state, directory);
                }
                for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                    writer.end();
                }
            }
            catch (IOException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            ** for (writer : state.getWriters().values())
        }
lbl-1000:
        // 1 sources

        {
            writer.close();
            continue;
        }
lbl28:
        // 1 sources

    }

    private void loopAllRpmsAndAppend(CreateRepoState state, YumDirectory directory) throws IOException, XMLStreamException {
        for (Asset rpmAsset : this.browseAllRpms(state, directory)) {
            this.appendRpm(state, directory, rpmAsset);
        }
    }

    private void appendRpm(CreateRepoState state, YumDirectory directory, Asset rpmAsset) throws IOException, XMLStreamException {
        this.log.debug("Adding RPM {} to metadata for repository {} and directory {}", new Object[]{rpmAsset.name(), state.getRepository().getName(), directory.getName()});
        Blob blob = state.getTx().getBlob(rpmAsset.requireBlobRef());
        this.writeAssetToMetadata(state, rpmAsset, blob);
    }

    private void appendCachedEntries(CreateRepoState state, YumDirectory directory, Set<String> newRpms) throws XMLStreamException, IOException {
        Map<YumMetadataType, Asset> repodata = this.findRepodata(state, directory);
        if (!this.allMetadataExists(repodata)) {
            this.log.warn("A metadata file was deleted during metadata generation, falling back to non-cached method");
            this.loopAllRpmsAndAppend(state, directory);
            return;
        }
        MetadataWriter<YumRpm> primaryWriter = state.getWriters().get((Object)YumMetadataType.PRIMARY);
        Asset primaryXml = repodata.get((Object)YumMetadataType.PRIMARY);
        Blob primaryXmlBlob = state.getTx().getBlob(primaryXml.requireBlobRef());
        if (primaryXmlBlob != null) {
            InputStream xml = this.gzipIn(primaryXmlBlob.getInputStream());
            Set<String> excludedChecksums = this.writeToPrimaryUsingCache(state, newRpms, primaryWriter, xml, directory);
            this.writeNonPrimaryFilesUsingCache(state, repodata, excludedChecksums);
        }
    }

    private void writeNonPrimaryFilesUsingCache(CreateRepoState state, Map<YumMetadataType, Asset> repodata, Set<String> excludedChecksums) throws XMLStreamException, IOException {
        for (Map.Entry<YumMetadataType, MetadataWriter<YumRpm>> entry : state.getWriters().entrySet()) {
            YumMetadataType type = entry.getKey();
            if (type == YumMetadataType.PRIMARY) continue;
            MetadataWriter<YumRpm> writer = entry.getValue();
            Asset asset = repodata.get((Object)type);
            if (asset == null) continue;
            Blob metadataXml = state.getTx().getBlob(asset.requireBlobRef());
            writer.copyFromXml(this.gzipIn(metadataXml.getInputStream()), PACKAGE, block -> {
                String checksum = new AttributeXmlValueExtractor(PACKAGE, "pkgid").extract((Collection<XMLEvent>)block);
                return !excludedChecksums.contains(checksum);
            });
        }
    }

    private Set<String> writeToPrimaryUsingCache(CreateRepoState state, Set<String> addedRpms, MetadataWriter<YumRpm> primaryWriter, InputStream xml, YumDirectory directory) throws XMLStreamException {
        HashSet<String> excludedChecksums = new HashSet<String>();
        primaryWriter.copyFromXml(xml, PACKAGE, block -> {
            String location = new AttributeXmlValueExtractor(LOCATION, LOCATION_ATTRIBUTE).extract((Collection<XMLEvent>)block);
            if (location != null && !addedRpms.contains(location) && this.rpmExists(state, location, directory)) {
                return true;
            }
            String checksum = new ElementXmlValueExtractor(CHECKSUM).extract((Collection<XMLEvent>)block);
            if (checksum != null) {
                excludedChecksums.add(checksum);
            }
            return false;
        });
        return excludedChecksums;
    }

    private boolean rpmExists(CreateRepoState state, String location, YumDirectory directory) {
        String path = location;
        if (StringUtils.isNotBlank((CharSequence)directory.getName())) {
            path = String.valueOf(directory.getName()) + "/" + location;
        }
        return !directory.isRpmsRemoved() || state.getTx().assetExists(path, state.getRepository());
    }

    private InputStream gzipIn(InputStream inputStream) throws IOException {
        return new GzipCompressorInputStream((InputStream)new BufferedInputStream(inputStream));
    }

    private Map<YumMetadataType, Asset> findRepodata(CreateRepoState state, YumDirectory directory) {
        HashMap<YumMetadataType, Asset> repodata = new HashMap<YumMetadataType, Asset>();
        Iterable<Asset> metadata = this.yumQueryComponent.findRepodataAssetsOnPath(state.getTx(), state.getRepository(), YumPathUtils.repodataPath(directory));
        for (Asset metadataAsset : metadata) {
            if (metadataAsset.name().contains("primary.xml")) {
                repodata.put(YumMetadataType.PRIMARY, metadataAsset);
                continue;
            }
            if (metadataAsset.name().contains("filelists.xml")) {
                repodata.put(YumMetadataType.FILELISTS, metadataAsset);
                continue;
            }
            if (!metadataAsset.name().contains("other.xml")) continue;
            repodata.put(YumMetadataType.OTHER, metadataAsset);
        }
        return repodata;
    }

    private void writeAssetToMetadata(CreateRepoState state, Asset rpmAsset, @Nullable Blob blob) throws IOException, XMLStreamException {
        block11: {
            if (blob != null) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (InputStream in = blob.getInputStream();){
                    YumRpm rpm = this.rpmParser.parse(in, this.rpmLocationRelativeToDepth(rpmAsset, state.getRepodataDepth()));
                    for (MetadataWriter<YumRpm> writer : state.getWriters().values()) {
                        writer.append(rpm);
                    }
                    break block11;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.log.warn("Excluding {} from the generated metadata because the blob could not be found", (Object)rpmAsset.name());
        }
    }

    private String rpmLocationRelativeToDepth(Asset rpmAsset, int depth) {
        if (depth == 0) {
            return rpmAsset.name();
        }
        String rootDirectory = YumPathUtils.extractDirectoryAtDepth(rpmAsset.name(), depth).orElse(rpmAsset.name());
        return rpmAsset.name().substring(rootDirectory.length() + 1);
    }

    private TempBlob convertFileToTempBlob(Path tempFile, Repository repository) throws IOException {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream tempFileInputStream = Files.newInputStream(tempFile, new OpenOption[0]);){
            return storageFacet.createTempBlob(tempFileInputStream, YumFacetUtils.HASH_ALGORITHMS);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean useCachedMetadata(CreateRepoState state) {
        return this.useCachedMetadata(state, null);
    }

    private boolean useCachedMetadata(CreateRepoState state, YumDirectory directory) {
        YumHostedFacet hosted = (YumHostedFacet)state.getRepository().facet(YumHostedFacet.class);
        if (state.isUseCache() && hosted.getMetadataGenerationStartedTime() > 0L) {
            if (directory == null && state.getRepodataDepth() > 0) {
                return true;
            }
            Map<YumMetadataType, Asset> repodata = this.findRepodata(state, directory);
            return this.allMetadataExists(repodata);
        }
        return false;
    }

    private boolean allMetadataExists(Map<YumMetadataType, Asset> repodata) {
        return repodata.containsKey((Object)YumMetadataType.PRIMARY) && repodata.containsKey((Object)YumMetadataType.FILELISTS) && repodata.containsKey((Object)YumMetadataType.OTHER);
    }

    private Iterable<Asset> browseRpmsForDirectoryCalculation(CreateRepoState state) {
        if (this.useCachedMetadata(state)) {
            return this.browseNewRpms(state, null);
        }
        return this.browseAllRpms(state, null);
    }

    private Iterable<Asset> browseNewRpms(CreateRepoState state, YumDirectory directory) {
        String path = directory != null ? directory.getName() : "";
        YumHostedFacet hosted = (YumHostedFacet)state.getRepository().facet(YumHostedFacet.class);
        return this.yumQueryComponent.browseRpmsSince(path, state.getTx(), state.getRepository(), hosted.getMetadataGenerationStartedTime());
    }

    private Iterable<Asset> browseAllRpms(CreateRepoState state, YumDirectory directory) {
        String path = directory != null ? directory.getName() : "";
        return this.yumQueryComponent.browseRpmsForPath(path, state.getTx(), state.getRepository());
    }
}

