/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumDirectory;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;

class CreateRepoState {
    private final StorageTx tx;
    private final Repository repository;
    private final int repodataDepth;
    private final List<YumDirectory> directories = new ArrayList<YumDirectory>();
    private final Map<YumMetadataType, MetadataWriter<YumRpm>> writers = new HashMap<YumMetadataType, MetadataWriter<YumRpm>>();
    private final boolean useCache;

    CreateRepoState(StorageTx tx, Repository repository, Integer repodataDepth, boolean useCache) {
        this.tx = (StorageTx)Preconditions.checkNotNull((Object)tx);
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.repodataDepth = repodataDepth != null ? repodataDepth : 0;
        this.useCache = useCache;
    }

    public StorageTx getTx() {
        return this.tx;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public int getRepodataDepth() {
        return this.repodataDepth;
    }

    public List<YumDirectory> getDirectories() {
        return this.directories;
    }

    public void addDirectory(YumDirectory directory) {
        this.directories.add(directory);
    }

    public Map<YumMetadataType, MetadataWriter<YumRpm>> getWriters() {
        return this.writers;
    }

    public void putWriter(YumMetadataType type, MetadataWriter<YumRpm> writer) {
        this.writers.put(type, writer);
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public static class CreateRepoStateBuilder {
        private StorageTx tx;
        private Repository repository;
        private Integer repodataDepth;
        private boolean useCache;

        public CreateRepoStateBuilder withTx(StorageTx tx) {
            this.tx = tx;
            return this;
        }

        public CreateRepoStateBuilder withRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public CreateRepoStateBuilder withRepodataDepth(Integer repodataDepth) {
            this.repodataDepth = repodataDepth;
            return this;
        }

        public CreateRepoStateBuilder withUseCache(boolean useCache) {
            this.useCache = useCache;
            return this;
        }

        public CreateRepoState build() {
            return new CreateRepoState(this.tx, this.repository, this.repodataDepth, this.useCache);
        }
    }
}

