/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.collect.ImmutableMap;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.sonatype.nexus.repository.yum.internal.createrepo.FilesMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;

public class FileListMetadataWriter
extends FilesMetadataWriter {
    public FileListMetadataWriter(OutputStream out) throws XMLStreamException {
        super(out);
    }

    @Override
    protected void startMetadata(int numberOfPackages) throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("filelists");
        this.writer.writeAttribute("xmlns", "http://linux.duke.edu/metadata/filelists");
        this.writer.writeAttribute("packages", Integer.toString(numberOfPackages));
    }

    @Override
    public void append(YumRpm rpm) throws XMLStreamException {
        this.writer.writeStartElement("package");
        this.writer.writeAttribute("pkgid", rpm.getPkgId());
        this.writer.writeAttribute("name", rpm.getName());
        this.writer.writeAttribute("arch", rpm.getArch());
        this.writeElement("version", null, (Map<String, Object>)ImmutableMap.of((Object)"epoch", (Object)rpm.getEpoch(), (Object)"ver", (Object)rpm.getVersion(), (Object)"rel", (Object)rpm.getRelease()));
        this.writeFiles(rpm.getFiles(), f -> true);
        this.writer.writeEndElement();
    }
}

