/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

public abstract class MetadataWriter<T>
implements Closeable {
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private final OutputStream out;
    protected final XMLStreamWriter writer;
    private boolean started;

    public MetadataWriter(OutputStream out) throws XMLStreamException {
        this.out = (OutputStream)Preconditions.checkNotNull((Object)out);
        this.writer = this.prettyPrintXmlWriter();
    }

    private XMLStreamWriter prettyPrintXmlWriter() throws XMLStreamException {
        TransformerHandler transformingSAXHandler;
        SAXTransformerFactory xmlTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            transformingSAXHandler = xmlTransformerFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new XMLStreamException(e);
        }
        Transformer xmlTransformer = transformingSAXHandler.getTransformer();
        xmlTransformer.setOutputProperty("indent", "yes");
        transformingSAXHandler.setResult(new StreamResult(this.out));
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        return xmlOutputFactory.createXMLStreamWriter(this.out, "UTF-8");
    }

    public void start(int numberOfPackages) throws XMLStreamException {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Cannot start xml file more than once");
        this.started = true;
        this.startMetadata(numberOfPackages);
    }

    public void end() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    @Override
    public void close() {
        try {
            this.writer.close();
            this.out.close();
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeElement(String name, Object text) throws XMLStreamException {
        this.writeElement(null, name, text, null);
    }

    protected void writeElement(String prefix, String name, @Nullable String text) throws XMLStreamException {
        this.writeElement(prefix, name, text, null);
    }

    protected void writeElement(String name, @Nullable Object text, Map<String, Object> attributes) throws XMLStreamException {
        this.writeElement(null, name, text, attributes);
    }

    protected void writeElement(@Nullable String prefix, String name, @Nullable Object text, @Nullable Map<String, Object> attributes) throws XMLStreamException {
        if (prefix != null) {
            this.writer.writeStartElement(prefix, name, "");
        } else {
            this.writer.writeStartElement(name);
        }
        if (attributes != null) {
            for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                if (attribute.getValue() == null) continue;
                this.writer.writeAttribute(attribute.getKey(), attribute.getValue().toString());
            }
        }
        if (text != null) {
            this.writer.writeCharacters(text.toString());
        }
        this.writer.writeEndElement();
    }

    @VisibleForTesting
    void append(Collection<XMLEvent> block) throws XMLStreamException {
        this.writer.writeCharacters("");
        this.writer.flush();
        XMLEventWriter eventWriter = xmlOutputFactory.createXMLEventWriter(this.out, "UTF-8");
        for (XMLEvent event : block) {
            eventWriter.add(event);
        }
        eventWriter.flush();
    }

    public void copyFromXml(InputStream source, String blockTag, Function<Collection<XMLEvent>, Boolean> include) throws XMLStreamException {
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(source);
        ArrayList<XMLEvent> block = new ArrayList<XMLEvent>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (!block.isEmpty()) {
                block.add(xmlEvent);
            }
            if (block.isEmpty() && xmlEvent.isStartElement() && xmlEvent.asStartElement().getName().getLocalPart().equals(blockTag)) {
                block.add(xmlEvent);
            }
            if (block.isEmpty() || !xmlEvent.isEndElement() || !xmlEvent.asEndElement().getName().getLocalPart().equals(blockTag)) continue;
            if (include.apply(block).booleanValue()) {
                this.append((T)block);
            }
            block.clear();
        }
    }

    protected abstract void startMetadata(int var1) throws XMLStreamException;

    public abstract void append(T var1) throws XMLStreamException;
}

