/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.collect.ImmutableMap;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmChangeLog;

public class OtherMetadataWriter
extends MetadataWriter<YumRpm> {
    private static final int CHANGE_LOG_LIMIT = 10;

    public OtherMetadataWriter(OutputStream out) throws XMLStreamException {
        super(out);
    }

    @Override
    protected void startMetadata(int numberOfPackages) throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("otherdata");
        this.writer.writeAttribute("xmlns", "http://linux.duke.edu/metadata/other");
        this.writer.writeAttribute("packages", Integer.toString(numberOfPackages));
    }

    @Override
    public void append(YumRpm rpm) throws XMLStreamException {
        this.writer.writeStartElement("package");
        this.writer.writeAttribute("pkgid", rpm.getPkgId());
        this.writer.writeAttribute("name", rpm.getName());
        this.writer.writeAttribute("arch", rpm.getArch());
        this.writeElement("version", null, (Map<String, Object>)ImmutableMap.of((Object)"epoch", (Object)rpm.getEpoch(), (Object)"ver", (Object)rpm.getVersion(), (Object)"rel", (Object)rpm.getRelease()));
        this.writeChanges(rpm.getChanges());
        this.writer.writeEndElement();
    }

    private void writeChanges(List<YumRpmChangeLog> changes) throws XMLStreamException {
        if (changes != null && !changes.isEmpty()) {
            List sortedChanges = changes.stream().sorted(Comparator.comparing(YumRpmChangeLog::getDate).reversed()).limit(10L).collect(Collectors.toList());
            for (YumRpmChangeLog change : sortedChanges) {
                this.writeElement("changelog", (Object)change.getText(), (Map<String, Object>)ImmutableMap.of((Object)"author", (Object)change.getAuthor(), (Object)"date", (Object)change.getDate()));
            }
        }
    }
}

