/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.createrepo;

import com.google.common.collect.ImmutableMap;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.sonatype.nexus.repository.yum.internal.createrepo.MetadataWriter;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

public class RepomdMetadataWriter
extends MetadataWriter<YumMetadata> {
    private int startTime;

    public RepomdMetadataWriter(OutputStream out, int startTime) throws XMLStreamException {
        super(out);
        this.startTime = startTime;
    }

    @Override
    public void startMetadata(int numberOfPackages) throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("repomd");
        this.writer.writeAttribute("xmlns", "http://linux.duke.edu/metadata/repo");
        this.writer.writeAttribute("xmlns:rpm", "http://linux.duke.edu/metadata/rpm");
        this.writeElement("revision", this.startTime);
    }

    @Override
    public void append(YumMetadata file) throws XMLStreamException {
        this.writer.writeStartElement("data");
        String type = file.getType().getType();
        this.writer.writeAttribute("type", type);
        ImmutableMap sha256 = ImmutableMap.of((Object)"type", (Object)"sha256");
        this.writeElement("checksum", (Object)file.getChecksum(), (Map<String, Object>)sha256);
        this.maybeWriteOpenChecksum(file, (Map<String, Object>)sha256);
        String path = this.buildFileName(file, type);
        this.writeElement("location", null, (Map<String, Object>)ImmutableMap.of((Object)"href", (Object)path));
        this.writeElement("timestamp", this.startTime);
        this.writeElement("size", file.getSize());
        this.maybeWriteOpenSize(file);
        this.writer.writeEndElement();
    }

    private void maybeWriteOpenChecksum(YumMetadata file, Map<String, Object> sha256) throws XMLStreamException {
        if (file.getOpenChecksum() != null) {
            this.writeElement("open-checksum", (Object)file.getOpenChecksum(), sha256);
        }
    }

    private void maybeWriteOpenSize(YumMetadata file) throws XMLStreamException {
        if (file.getOpenSize() > 0L) {
            this.writeElement("open-size", file.getOpenSize());
        }
    }

    private String buildFileName(YumMetadata file, String type) {
        switch (file.getType()) {
            case COMPS: {
                return "repodata/comps.xml";
            }
            case COMPS_GZ: {
                return "repodata/comps.xml.gz";
            }
        }
        return YumPathUtils.buildMetadataFilePath(file.getChecksum(), type);
    }
}

