/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.database;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.AbstractMetadataNode;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.yum.AssetKind;

@Named
@Singleton
public class YumQueryComponent
extends ComponentSupport {
    private static final String ASSET_KIND_KEY = "attributes.yum.asset_kind";
    private static final String RPMS_REMOVED_KEY = "attributes.yum.rpms_removed";
    private static final String P_LAST_UPDATED = "last_updated";
    private static final String RPMS_SINCE_QUERY = "SELECT FROM asset WHERE bucket=:bucket AND last_updated > :lastupdated AND component IS NOT NULL";
    private static final String REPOMD_PATH = "repodata/repomd.xml";
    private static final String COMPS_PATH = "repodata/comps.xml";
    private static final String DB_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final AssetEntityAdapter assetEntityAdapter;

    @Inject
    public YumQueryComponent(AssetEntityAdapter assetEntityAdapter) {
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
    }

    @Nullable
    public Component findComponent(StorageTx tx, Repository repository, String name, String version) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    public Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    public Iterable<Asset> findRepodataAssets(StorageTx tx, Repository repository) {
        Query query = Query.builder().where("component").isNull().and("name").like((Object)"%repodata/%").and(ASSET_KIND_KEY).eq((Object)AssetKind.REPODATA.name()).build();
        return tx.findAssets(query, Collections.singletonList(repository));
    }

    public Iterable<Asset> findRepodataAssetsOnPath(StorageTx tx, Repository repository, String path) {
        Query query = Query.builder().where("component").isNull().and("name").like((Object)(String.valueOf(path) + "%")).and(ASSET_KIND_KEY).eq((Object)AssetKind.REPODATA.name()).build();
        return tx.findAssets(query, Collections.singletonList(repository));
    }

    public Iterable<Asset> findRepomd(StorageTx tx, Repository repository) {
        return this.findRepomdOnPath(tx, repository, null);
    }

    public Iterable<Asset> findRepomdOnPath(StorageTx tx, Repository repository, @Nullable String path) {
        Query.Builder builder = Query.builder();
        if (StringUtils.isNotBlank((CharSequence)path)) {
            builder.where("name").eq((Object)(String.valueOf(path) + "/" + REPOMD_PATH));
        } else {
            builder.where("name").eq((Object)REPOMD_PATH);
        }
        builder.and(ASSET_KIND_KEY).eq((Object)AssetKind.REPOMD.name());
        return tx.findAssets(builder.build(), Collections.singletonList(repository));
    }

    public Iterable<Asset> browseRpms(StorageTx tx, Repository repository) {
        return Iterables.filter((Iterable)tx.browseAssets(tx.findBucket(repository)), asset -> AssetKind.RPM.toString().equals(asset.formatAttributes().get("asset_kind", String.class)));
    }

    public Iterable<Asset> browseRpmsForPath(String path, StorageTx tx, Repository repository) {
        Query.Builder builder = Query.builder().where("component").isNotNull();
        if (!StringUtils.isBlank((CharSequence)path)) {
            builder.and("name").like((Object)(String.valueOf(path) + "%"));
        }
        Query query = builder.and(ASSET_KIND_KEY).eq((Object)AssetKind.RPM.name()).build();
        return tx.browseAssets(query, tx.findBucket(repository));
    }

    public Iterable<Asset> browseRpmsSince(@Nullable String path, StorageTx tx, Repository repository, long since) {
        String query = RPMS_SINCE_QUERY;
        if (StringUtils.isNotBlank((CharSequence)path)) {
            query = String.valueOf(query) + " AND name LIKE :path";
        }
        Bucket bucket = tx.findBucket(repository);
        ImmutableMap params = ImmutableMap.of((Object)"bucket", (Object)AttachedEntityHelper.id((Entity)bucket), (Object)"lastupdated", (Object)this.convertTimeStampToQueryableDate(since), (Object)"path", (Object)(String.valueOf(path) + "%"));
        return Iterables.transform((Iterable)tx.browse(query, (Map)params), arg_0 -> ((AssetEntityAdapter)this.assetEntityAdapter).readEntity(arg_0));
    }

    private String convertTimeStampToQueryableDate(long since) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(since), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(DB_DATE_FORMAT));
    }

    public Iterable<Asset> findCompsByPath(@Nullable String path, StorageTx tx, Repository repository) {
        String expectedPath = StringUtils.isNotBlank((CharSequence)path) ? String.valueOf(path) + "/" + COMPS_PATH : COMPS_PATH;
        Query query = Query.builder().where("name").eq((Object)expectedPath).or("name").eq((Object)(String.valueOf(expectedPath) + ".gz")).build();
        return tx.findAssets(query, Collections.singletonList(repository));
    }

    public long countRpms(StorageTx tx, Repository repository) {
        return this.countRpmsInDirectory(null, tx, repository);
    }

    public long countRpmsInDirectory(@Nullable String folder, StorageTx tx, Repository repository) {
        Query.Builder query = Query.builder();
        query.where("component").isNotNull();
        if (StringUtils.isNotBlank((CharSequence)folder)) {
            query = query.and("name").like((Object)(String.valueOf(folder) + "%"));
        }
        return tx.countAssets(query.build(), Collections.singletonList(repository));
    }

    public List<String> getMetadataPathsThatHaveHadRpmsRemoved(StorageTx tx, Repository repository) {
        Query.Builder builder = Query.builder().where("component").isNull().and("name").like((Object)"%repomd.xml").and(ASSET_KIND_KEY).eq((Object)AssetKind.REPOMD.name()).and(RPMS_REMOVED_KEY).eq((Object)true);
        return StreamSupport.stream(tx.findAssets(builder.build(), Collections.singletonList(repository)).spliterator(), false).map(AbstractMetadataNode::name).collect(Collectors.toList());
    }
}

