/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.group;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.yum.YumFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.database.YumQueryComponent;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupFacet;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupMerger;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdCreator;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdInvalidatorFacet;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdInvalidatorFacetImpl;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdParser;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRequest;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class YumGroupFacetImpl
extends GroupFacetImpl
implements YumGroupFacet {
    private static final String REPOMD_FILE = "repomd.xml";
    private static final String REPODATA = "repodata";
    private final YumGroupRepomdCreator groupRepomdCreator;
    private final YumGroupMerger groupMerger;
    private final YumGroupRepomdParser groupRepomdParser;
    private final YumQueryComponent yumQueryComponent;
    private YumFacet yumFacet;
    private YumGroupRepomdInvalidatorFacet yumGroupRepomdInvalidatorFacet;
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation repomdCooperation;

    @Inject
    public YumGroupFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType, YumGroupRepomdCreator groupRepomdCreator, YumGroupMerger groupMerger, YumGroupRepomdParser groupRepomdParser, YumQueryComponent yumQueryComponent) {
        super(repositoryManager, constraintViolationFactory, groupType);
        this.groupRepomdCreator = (YumGroupRepomdCreator)Preconditions.checkNotNull((Object)groupRepomdCreator);
        this.groupMerger = (YumGroupMerger)Preconditions.checkNotNull((Object)groupMerger);
        this.groupRepomdParser = (YumGroupRepomdParser)Preconditions.checkNotNull((Object)groupRepomdParser);
        this.yumQueryComponent = (YumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryComponent)));
    }

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.repomd.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.repomd.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.repomd.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.repomd.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    void buildCooperation() {
        if (this.cooperationBuilder != null) {
            this.repomdCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":repomd");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.yumFacet = (YumFacet)this.facet(YumFacet.class);
        this.yumGroupRepomdInvalidatorFacet = (YumGroupRepomdInvalidatorFacet)this.facet(YumGroupRepomdInvalidatorFacetImpl.class);
        this.buildCooperation();
    }

    @Override
    @Nullable
    public Content buildRepomd(String path, Map<Repository, InputStream> repositoriesResponseMap, Context context) {
        if (Objects.isNull(this.repomdCooperation)) {
            return this.buildMergedRepomd(path, repositoriesResponseMap, context);
        }
        String requestPath = this.getRequestPath(context);
        try {
            return (Content)this.repomdCooperation.cooperate(requestPath, failover -> {
                Content cachedContent;
                if (failover && Objects.nonNull(cachedContent = (Content)this.repomdCooperation.join(() -> this.get(requestPath)))) {
                    this.log.debug("Using cached metadata for repository {}", (Object)context.getRepository().getName());
                    return cachedContent;
                }
                return this.buildMergedRepomd(path, repositoriesResponseMap, context);
            });
        }
        catch (IOException e) {
            this.log.error("Unable to use Cooperation to merge {} for repository {}", new Object[]{requestPath, context.getRepository().getName(), e});
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    protected Content buildMergedRepomd(String path, Map<Repository, InputStream> repositoriesResponseMap, Context context) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull(repositoriesResponseMap);
        Preconditions.checkNotNull((Object)context);
        if (repositoriesResponseMap.isEmpty()) {
            this.log.debug("Unable to create metadata for repository {}. Members had no metadata to merge.", (Object)context.getRepository().getName());
            return null;
        }
        this.log.info("Creating latest metadata by merging metadata of group members for repository {}", (Object)context.getRepository().getName());
        List<YumMetadataFile> metadataCollection = Collections.emptyList();
        Map<YumMetadataType, List<YumGroupRequest>> repodataFiles = this.groupRepomdParser.parse(repositoriesResponseMap);
        try {
            Content content;
            metadataCollection = this.groupMerger.fetchAndMergeMetadata(path, repodataFiles, context);
            YumMetadataFile repomdFile = this.groupRepomdCreator.create(metadataCollection);
            if (repomdFile != null) {
                metadataCollection.add(repomdFile);
            }
            if (Objects.nonNull(content = this.saveAllAndDiscardUnused(metadataCollection, YumPathUtils.appendPath(path, REPODATA)))) {
                this.yumGroupRepomdInvalidatorFacet.markRepomdAssetToUseCache(path);
            }
            Content content2 = content;
            return content2;
        }
        finally {
            this.cleanupFiles(metadataCollection);
        }
    }

    @Override
    @Nullable
    public Content get(String requestPath) {
        String path = requestPath.substring(1);
        try {
            return this.yumFacet.getAssetAsContent(path);
        }
        catch (IOException e) {
            this.log.warn("Unable to fetch {}", (Object)path, (Object)e);
            return null;
        }
    }

    public List<Repository> leafMembers() {
        List repositories = super.leafMembers();
        repositories.add(0, this.getRepository());
        return repositories;
    }

    @Nullable
    private Content saveAllAndDiscardUnused(List<YumMetadataFile> metadataCollection, String path) {
        Iterable<Asset> currentMetadata = this.retrieveCurrentMetadata(path);
        List<Asset> savedAssets = this.saveMetadata(metadataCollection, path);
        this.discardUnusedMetadata(Lists.newArrayList(currentMetadata), savedAssets);
        try {
            return this.yumFacet.getAssetAsContent(YumPathUtils.appendPath(path, REPOMD_FILE));
        }
        catch (IOException e) {
            this.log.error("Unable to find asset {}", (Object)path, (Object)e);
            return null;
        }
    }

    @TransactionalTouchMetadata
    protected Iterable<Asset> retrieveCurrentMetadata(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return this.yumQueryComponent.findRepodataAssetsOnPath(tx, this.getRepository(), path);
    }

    @TransactionalDeleteBlob
    protected void deleteMetadata(Asset asset) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        tx.deleteAsset(asset);
    }

    private void discardUnusedMetadata(List<Asset> currentMetadata, List<Asset> newMetadata) {
        currentMetadata.stream().filter(metadata -> this.doesntExistIn((Asset)metadata, newMetadata)).collect(Collectors.toList()).forEach(this::deleteMetadata);
    }

    private boolean doesntExistIn(Asset currentMeta, List<Asset> newMetadata) {
        return newMetadata.stream().noneMatch(newMeta -> newMeta.name().equals(currentMeta.name()));
    }

    private List<Asset> saveMetadata(List<YumMetadataFile> metadataCollection, String path) {
        try {
            ArrayList<Asset> savedAssets = new ArrayList<Asset>();
            for (YumMetadataFile yumMetadataFile : metadataCollection) {
                Asset asset = this.save(path, yumMetadataFile);
                if (asset == null) continue;
                savedAssets.add(asset);
            }
            return savedAssets;
        }
        catch (IOException e) {
            this.log.error("Unable to save metadata to {}", (Object)path, (Object)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    @TransactionalTouchMetadata
    protected Asset getAssetFromContent(Content content) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
    }

    private void cleanupFiles(List<YumMetadataFile> metadataCollection) {
        metadataCollection.forEach(file -> {
            try {
                String filePath;
                Path path;
                if (Objects.nonNull(file) && Objects.nonNull(path = file.getPath()) && Objects.nonNull(filePath = path.toString()) && !filePath.isEmpty()) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                this.log.error("Unable to delete {}", (Object)file.getPath(), (Object)e);
            }
        });
    }

    @Nullable
    private Asset save(String path, YumMetadataFile yumGroupFile) throws IOException {
        YumMetadata yumMetadata = this.getYumMetadata(yumGroupFile);
        TempBlob tempBlob = this.convertFileToTempBlob(this.getRepository(), yumGroupFile);
        if (tempBlob != null) {
            Content content = new Content((Payload)this.getStreamPayload(yumGroupFile, yumMetadata));
            Content metadata = this.yumFacet.storeMetadata(this.buildPath(path, yumMetadata), tempBlob, (Payload)content, yumGroupFile.getType().getKind());
            return this.getAssetFromContent(metadata);
        }
        return null;
    }

    private YumMetadata getYumMetadata(YumMetadataFile yumGroupFile) throws IOException {
        YumMetadata yumMetadata = yumGroupFile.getType().equals((Object)YumMetadataType.REPOMD) ? new YumMetadata(YumMetadataType.REPOMD) : YumMetadataUtils.readCompressedMetadata(yumGroupFile);
        return yumMetadata;
    }

    private StreamPayload getStreamPayload(final YumMetadataFile yumGroupFile, YumMetadata yumMetadata) throws IOException {
        return new StreamPayload(new StreamPayload.InputStreamSupplier(){

            @Nonnull
            public InputStream get() throws IOException {
                return new BufferedInputStream(Files.newInputStream(yumGroupFile.getPath(), new OpenOption[0]));
            }
        }, Files.size(yumGroupFile.getPath()), this.getContentType(yumMetadata));
    }

    private String getContentType(YumMetadata yumMetadata) {
        return yumMetadata.getType().getFileType().equals("xml") ? "application/xml" : "application/gzip";
    }

    @Nullable
    private TempBlob convertFileToTempBlob(Repository repository, YumMetadataFile yumGroupFile) throws IOException {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream tempFileInputStream = new BufferedInputStream(Files.newInputStream(yumGroupFile.getPath(), new OpenOption[0]));){
                return storageFacet.createTempBlob((InputStream)tempFileInputStream, YumFacetUtils.HASH_ALGORITHMS);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            this.log.warn("Unable to open file of type {} for reading", (Object)yumGroupFile.getType().getType(), (Object)e);
            return null;
        }
    }

    private String buildPath(String basePath, YumMetadata yumMetadata) {
        String filename = this.getFilename(yumMetadata) + this.getExtension(yumMetadata);
        if (basePath.endsWith("/")) {
            return String.valueOf(basePath) + filename;
        }
        return String.valueOf(basePath) + "/" + filename;
    }

    private String getFilename(YumMetadata yumMetadata) {
        String type = yumMetadata.getType().getType();
        if (type.equals(YumMetadataType.COMPS.getType()) || type.equals(YumMetadataType.COMPS_GZ.getType())) {
            return "comps";
        }
        if (type.equals(YumMetadataType.REPOMD.getType())) {
            return type;
        }
        return String.valueOf(yumMetadata.getChecksum()) + "-" + type;
    }

    private String getExtension(YumMetadata yumMetadata) {
        return "." + yumMetadata.getType().getFileType();
    }

    private String getRequestPath(Context context) {
        return context.getRequest().getPath().substring(1);
    }
}

