/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.group;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupMerger;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRequest;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMergeService;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;

@Singleton
@Named
public class YumGroupMergerImpl
extends ComponentSupport
implements YumGroupMerger {
    private final YumMergeService yumMergeService;

    @Inject
    public YumGroupMergerImpl(YumMergeService yumMergeService) {
        this.yumMergeService = (YumMergeService)Preconditions.checkNotNull((Object)yumMergeService);
    }

    @Override
    public List<YumMetadataFile> fetchAndMergeMetadata(String path, Map<YumMetadataType, List<YumGroupRequest>> metadataTypes, Context context) {
        return metadataTypes.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<YumMetadataType, List<InputStream>>((YumMetadataType)((Object)((Object)entry.getKey())), this.fetch(path, (List)entry.getValue(), context))).filter(tuple -> !((List)tuple.getValue()).isEmpty()).map(tuple -> this.mergeResponses((YumMetadataType)((Object)((Object)tuple.getKey())), (List)tuple.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<InputStream> fetch(String path, List<YumGroupRequest> groupRequests, Context context) {
        ArrayList<InputStream> responseStreams = new ArrayList<InputStream>();
        groupRequests.forEach(request -> {
            this.log.info("Requesting {} from {}", (Object)request.getLocation(), (Object)request.getRepository().getName());
            ViewFacet view = (ViewFacet)request.getRepository().facet(ViewFacet.class);
            try {
                Response response = view.dispatch(this.buildRequest(path, request.getLocation()), context);
                if (response.getStatus().getCode() == 200 && response.getPayload() != null) {
                    responseStreams.add(YumMetadataUtils.xmlInputStream(request.getLocation(), response.getPayload().openInputStream()));
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to dispatch get request of {} to {}", new Object[]{request.getLocation(), request.getRepository().getName(), e});
            }
        });
        return responseStreams;
    }

    private Request buildRequest(String path, String filename) {
        return new Request.Builder().action("GET").path("/" + YumPathUtils.appendPath(path, filename)).build();
    }

    @Nullable
    private YumMetadataFile mergeResponses(YumMetadataType metadataType, List<InputStream> responsesAsStreams) {
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile(metadataType.getType(), metadataType.getFileType(), new FileAttribute[0]);
            this.log.info("Merge of {} starting", (Object)metadataType.getType());
            Throwable throwable = null;
            Object var5_7 = null;
            try (GZIPOutputStream outputStream = new GZIPOutputStream(new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0])));){
                this.yumMergeService.merge(metadataType, outputStream, responsesAsStreams);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.log.info("Merge of {} completed", (Object)metadataType.getType());
            YumMetadataFile yumMetadataFile = new YumMetadataFile(metadataType, tempFile);
            return yumMetadataFile;
        }
        catch (IOException e) {
            this.log.error("Unable to create gzip outputstream of {}", (Object)metadataType.getType(), (Object)e);
            if (tempFile != null) {
                this.deleteFile(tempFile);
            }
        }
        finally {
            this.closeStreams(responsesAsStreams);
        }
        return null;
    }

    private void closeStreams(List<InputStream> responsesAsStreams) {
        for (InputStream responsesAsStream : responsesAsStreams) {
            try {
                responsesAsStream.close();
            }
            catch (IOException e) {
                this.log.error("Unable to close stream", (Throwable)e);
            }
        }
    }

    private void deleteFile(Path tempFile) {
        try {
            Files.deleteIfExists(tempFile);
        }
        catch (IOException e) {
            this.log.error("Unable to delete {}", (Object)tempFile, (Object)e);
        }
    }
}

