/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.group;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.yum.internal.createrepo.RepomdMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.group.YumGroupRepomdCreator;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;

@Singleton
@Named
public class YumGroupRepomdCreatorImpl
extends ComponentSupport
implements YumGroupRepomdCreator {
    private final Clock clock;

    @Inject
    public YumGroupRepomdCreatorImpl(Clock clock) {
        this.clock = clock;
    }

    @Override
    public YumMetadataFile create(List<YumMetadataFile> metadataList) {
        Path tempFile = this.getTemporaryFile();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RepomdMetadataWriter repomdMetadataWriter = new RepomdMetadataWriter(Files.newOutputStream(tempFile, new OpenOption[0]), this.getStartTime());){
                repomdMetadataWriter.startMetadata(metadataList.size());
                this.readMetadataAndAppendToRepomd(metadataList, repomdMetadataWriter);
                repomdMetadataWriter.end();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException e) {
            this.log.error("Unable to create repomd file");
            this.deleteFile(tempFile);
            throw new RuntimeException(e);
        }
        return new YumMetadataFile(YumMetadataType.REPOMD, tempFile);
    }

    private void deleteFile(Path tempFile) {
        try {
            Files.deleteIfExists(tempFile);
        }
        catch (IOException e) {
            this.log.error("Unable to delete {}", (Object)tempFile, (Object)e);
        }
    }

    private int getStartTime() {
        return (int)(this.clock.millis() / 1000L);
    }

    private Path getTemporaryFile() {
        Path tempFile;
        try {
            tempFile = Files.createTempFile(YumMetadataType.REPOMD.getType(), YumMetadataType.REPOMD.getFileType(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.log.error("Unable to create temporary file for repomd");
            throw new RuntimeException(e);
        }
        return tempFile;
    }

    private void readMetadataAndAppendToRepomd(List<YumMetadataFile> metadataCollection, RepomdMetadataWriter repomdMetadataWriter) {
        metadataCollection.forEach(yumGroupFile -> {
            if (yumGroupFile.getType() != YumMetadataType.REPOMD) {
                try {
                    YumMetadata metadata = YumMetadataUtils.readCompressedMetadata(yumGroupFile);
                    if (metadata != null) {
                        repomdMetadataWriter.append(metadata);
                    }
                }
                catch (IOException | XMLStreamException e) {
                    this.log.error("Unable to append {} metadata to repomd", (Object)yumGroupFile.getType().getType(), (Object)e);
                }
            }
        });
    }
}

