/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.hosted;

import java.util.Collections;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.yum.internal.hosted.YumHostedFacet;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class YumHostedComponentMaintenanceFacet
extends DefaultComponentMaintenanceImpl {
    public Set<String> deleteAsset(EntityId assetId) {
        return (Set)Transactional.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).call(() -> this.deleteAssetTx(assetId, true));
    }

    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        Component component;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        this.log.info("Deleting asset: {}", (Object)asset);
        tx.deleteAsset(asset, deleteBlob);
        YumHostedFacet hostedFacet = (YumHostedFacet)this.facet(YumHostedFacet.class);
        hostedFacet.markMetadataAsRpmsRemoved(asset.name(), tx, true);
        if (asset.componentId() != null && !tx.browseAssets(component = tx.findComponentInBucket(asset.componentId(), bucket)).iterator().hasNext()) {
            this.log.debug("Deleting component: {}", (Object)component);
            tx.deleteComponent(component, deleteBlob);
        }
        return Collections.singleton(asset.name());
    }
}

