/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.hosted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.DeployPolicy;
import org.sonatype.nexus.repository.yum.YumFacet;
import org.sonatype.nexus.repository.yum.internal.database.YumQueryComponent;
import org.sonatype.nexus.repository.yum.internal.hosted.YumHostedFacet;
import org.sonatype.nexus.repository.yum.internal.hosted.YumHostedWritePolicySelector;
import org.sonatype.nexus.repository.yum.internal.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class YumHostedFacetImpl
extends FacetSupport
implements YumHostedFacet {
    private static final String CONFIG_KEY = "yum";
    public static final String RPMS_REMOVED_ATTRIBUTE = "rpms_removed";
    public static final String METADATA_GENERATION_TIME = "metadata_generation_time";
    private final YumQueryComponent yumQueryComponent;
    private YumFacet yumFacet;
    @VisibleForTesting
    Config config;

    @Inject
    public YumHostedFacetImpl(YumQueryComponent yumQueryComponent) {
        this.yumQueryComponent = (YumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryComponent)));
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.yumFacet = (YumFacet)this.facet(YumFacet.class);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new YumHostedWritePolicySelector());
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content get(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.yumQueryComponent.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return null;
        }
        return YumFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public void upload(String path, Payload payload, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)payload);
        if (assetKind != AssetKind.RPM && assetKind != AssetKind.COMPS && assetKind != AssetKind.NON_YUM) {
            throw new IllegalArgumentException("Unsupported assetKind: " + (Object)((Object)assetKind));
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = ((StorageFacet)this.facet(StorageFacet.class)).createTempBlob(payload, YumFacetUtils.HASH_ALGORITHMS);){
            if (assetKind == AssetKind.RPM) {
                this.validateRepodataDepth(path);
                this.yumFacet.storeRpm(path, (Supplier<InputStream>)tempBlob, payload);
            } else if (assetKind == AssetKind.COMPS) {
                this.putMetadata(path, tempBlob, payload.getContentType(), AssetKind.COMPS);
            } else if (assetKind == AssetKind.NON_YUM) {
                this.putNonYumFile(path, tempBlob, payload);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    void validateRepodataDepth(String path) {
        int depth = this.getPathDepth(path);
        if (depth < this.getRepodataDepth()) {
            throw new InvalidContentException(String.format("Uploading RPMs above the configured depth is not allowed. Repodata depth set to %d, RPM depth is lower (%d)", this.getRepodataDepth(), depth));
        }
    }

    private int getPathDepth(String path) {
        return path.split("/").length - 1;
    }

    @Override
    @TransactionalStoreBlob
    public Content putMetadata(String path, TempBlob content, String contentType, AssetKind assetKind) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        return this.doPutMetadata(path, content, contentType, assetKind, tx, bucket);
    }

    @TransactionalStoreBlob
    protected void putNonYumFile(String path, TempBlob tempBlob, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.yumFacet.findOrCreateAsset(path, AssetKind.NON_YUM, new AttributesMap(), tx, bucket);
        this.yumFacet.saveAsset(tx, asset, (Supplier<InputStream>)((Supplier)() -> tempBlob.get()), payload);
    }

    @Override
    public Integer getRepodataDepth() {
        return this.config.repodataDepth;
    }

    @Override
    public DeployPolicy getDeployPolicy() {
        return this.config.deployPolicy;
    }

    @Override
    @TransactionalDeleteBlob
    public boolean delete(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.yumQueryComponent.findAsset(tx, bucket, path);
        if (asset == null) {
            return false;
        }
        if (this.isMetadata(asset)) {
            throw new IllegalOperationException("Deletion of metadata forbidden");
        }
        tx.deleteAsset(asset);
        return true;
    }

    private boolean isMetadata(Asset asset) {
        String assetKind = (String)asset.formatAttributes().get("asset_kind", String.class);
        return Objects.equals(AssetKind.REPODATA.name(), assetKind) || Objects.equals(AssetKind.REPOMD.name(), assetKind) || Objects.equals(AssetKind.REPOMD_ASC.name(), assetKind);
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteAllGeneratedMetadata(List<String> directories, String ... excluding) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        List<String> excludeList = Arrays.asList(excluding);
        StreamSupport.stream(this.yumQueryComponent.findRepodataAssets(tx, this.getRepository()).spliterator(), false).filter(asset -> !excludeList.contains(asset.name())).filter(asset -> this.matchesDirectory(directories, (Asset)asset)).forEach(arg_0 -> ((StorageTx)tx).deleteAsset(arg_0));
    }

    private boolean matchesDirectory(List<String> directories, Asset asset) {
        return directories.isEmpty() || directories.contains(YumPathUtils.extractDirectoryFromMetadataPath(asset.name()));
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteRepomd() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        this.yumQueryComponent.findRepomd(tx, this.getRepository()).forEach(arg_0 -> ((StorageTx)tx).deleteAsset(arg_0));
    }

    @Override
    @TransactionalStoreMetadata
    public void metadataGenerationStarted(long at) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        bucket.attributes().set(METADATA_GENERATION_TIME, (Object)at);
        tx.saveBucket(bucket);
    }

    @Override
    @TransactionalTouchMetadata
    public long getMetadataGenerationStartedTime() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        if (bucket.attributes().contains(METADATA_GENERATION_TIME)) {
            return (Long)bucket.attributes().get(METADATA_GENERATION_TIME, Long.class);
        }
        return 0L;
    }

    @Override
    @TransactionalStoreMetadata
    public void setRpmsRemovedFlagIfCountChanged(String folder, long expectedRpmCount) {
        StorageTx tx;
        long count = this.yumQueryComponent.countRpmsInDirectory(folder, tx = (StorageTx)UnitOfWork.currentTx(), this.getRepository());
        this.markMetadataAsRpmsRemoved(folder, tx, count < expectedRpmCount);
    }

    @Override
    public void markMetadataAsRpmsRemoved(String location, StorageTx tx, boolean removed) {
        Integer repodataDepth = this.getRepodataDepth();
        Optional<String> directory = YumPathUtils.extractDirectoryAtDepth(location, repodataDepth);
        Iterable<Asset> metadata = this.yumQueryComponent.findRepomdOnPath(tx, this.getRepository(), directory.orElse(""));
        for (Asset metadataAsset : metadata) {
            if (removed) {
                metadataAsset.formatAttributes().set(RPMS_REMOVED_ATTRIBUTE, (Object)true);
            } else {
                metadataAsset.formatAttributes().remove(RPMS_REMOVED_ATTRIBUTE);
            }
            tx.saveAsset(metadataAsset);
        }
    }

    @Override
    public Integer getComponentDepth(Component component) {
        return this.getPathDepth(this.firstAssetFor(this.getRepository(), component).name());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Asset firstAssetFor(Repository repository, Component component) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            tx.begin();
            Iterator i = tx.browseAssets(component).iterator();
            return i.hasNext() ? (Asset)i.next() : null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutMetadata(String path, TempBlob content, String contentType, AssetKind assetKind, StorageTx tx, Bucket bucket) throws IOException {
        Asset asset = this.yumQueryComponent.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        }
        return this.yumFacet.saveAsset(tx, asset, (Supplier<InputStream>)content, contentType, new AttributesMap());
    }

    @VisibleForTesting
    static class Config {
        public Integer repodataDepth = 0;
        @NotNull(groups={HostedType.ValidationGroup.class})
        public DeployPolicy deployPolicy;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "repodataDepth=" + this.repodataDepth + ", deployPolicy=" + (Object)((Object)this.deployPolicy) + '}';
        }
    }
}

