/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.sonatype.nexus.repository.yum.internal.mergerepo.XmlBlockDeduper;

public class AttributeXmlBlockDeduper
extends XmlBlockDeduper {
    private final String elementName;
    private final QName attributeName;

    public AttributeXmlBlockDeduper(String blockName, String elementName, String attributeName) {
        super(blockName);
        Preconditions.checkNotNull((Object)elementName);
        Preconditions.checkNotNull((Object)attributeName);
        this.elementName = elementName;
        this.attributeName = new QName(attributeName);
    }

    @Override
    public boolean isUnique(List<XMLEvent> xmlEvents) {
        for (XMLEvent xmlEvent : xmlEvents) {
            if (!this.isAtElementWithAttributeId(xmlEvent)) continue;
            return this.addIfBlockUnique(this.getAttributeId(xmlEvent));
        }
        return false;
    }

    private boolean isAtElementWithAttributeId(XMLEvent xmlEvent) {
        return xmlEvent.isStartElement() && this.elementName.equals(xmlEvent.asStartElement().getName().getLocalPart());
    }

    private String getAttributeId(XMLEvent xmlEvent) {
        return xmlEvent.asStartElement().getAttributeByName(this.attributeName).getValue();
    }
}

