/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.sonatype.nexus.repository.yum.internal.mergerepo.XmlBlockDeduper;

public final class ElementXmlBlockDeduper
extends XmlBlockDeduper {
    private final String elementName;

    public ElementXmlBlockDeduper(String blockName, String elementName) {
        super(blockName);
        Preconditions.checkNotNull((Object)elementName);
        this.elementName = elementName;
    }

    @Override
    public boolean isUnique(List<XMLEvent> xmlEvents) {
        Preconditions.checkNotNull(xmlEvents);
        int i = 0;
        while (i < xmlEvents.size()) {
            XMLEvent xmlEvent = xmlEvents.get(i);
            if (xmlEvent.isStartElement() && this.elementName.equals(xmlEvent.asStartElement().getName().getLocalPart())) {
                return this.addIfBlockUnique(this.getDataContent(xmlEvents.get(i + 1)));
            }
            ++i;
        }
        return false;
    }

    private String getDataContent(XMLEvent xmlEvent) {
        return xmlEvent.asCharacters().getData();
    }
}

