/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.yum.internal.createrepo.RepomdMetadataWriter;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.mergerepo.YumMergeMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;

@Singleton
public class YumMergeRepomdWriter {
    @VisibleForTesting
    protected Clock clock = new Clock();

    public void write(OutputStream outputStream, YumMergeMetadata ... streams) {
        Preconditions.checkNotNull((Object)outputStream, (Object)streams);
        int startTimeInSeconds = (int)(this.clock.millis() / 1000L);
        try {
            RepomdMetadataWriter repomdMetadataWriter = new RepomdMetadataWriter(outputStream, startTimeInSeconds);
            repomdMetadataWriter.start(streams.length);
            YumMergeMetadata[] yumMergeMetadataArray = streams;
            int n = streams.length;
            int n2 = 0;
            while (n2 < n) {
                YumMergeMetadata file = yumMergeMetadataArray[n2];
                YumMetadata metadata = YumMetadataUtils.readCompressedMetadata(new YumMetadataFile(file.getYumMetadataType(), Paths.get(file.getYumMetadataType().getFileType(), new String[0])), file.getInputStream());
                repomdMetadataWriter.append(metadata);
                ++n2;
            }
            repomdMetadataWriter.end();
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }
}

