/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.mergerepo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.repository.yum.internal.mergerepo.FindAndReplace;
import org.sonatype.nexus.repository.yum.internal.mergerepo.XmlBlockDeduper;

public class YumMetadataMerger {
    private static final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private final List<XmlBlockDeduper> xmlBlockDedupers;
    private final String elementName;
    private final List<Attribute> attributes;
    private final List<XMLEvent> packageEvents = new ArrayList<XMLEvent>();
    private final FindAndReplace findAndReplace;

    YumMetadataMerger(FindAndReplace findAndReplace, List<XmlBlockDeduper> xmlBlockDedupers, String elementName, Map<String, String> attributes) {
        Preconditions.checkNotNull((Object)findAndReplace);
        Preconditions.checkNotNull(xmlBlockDedupers);
        Preconditions.checkNotNull((Object)elementName);
        Preconditions.checkNotNull(attributes);
        this.findAndReplace = findAndReplace;
        this.xmlBlockDedupers = xmlBlockDedupers;
        this.elementName = elementName;
        this.attributes = ImmutableList.builder().addAll((Iterable)attributes.entrySet().stream().map(attribute -> xmlEventFactory.createAttribute((String)attribute.getKey(), (String)attribute.getValue())).collect(Collectors.toList())).build();
    }

    YumMetadataMerger(List<XmlBlockDeduper> xmlBlockDedupers, String elementName, Map<String, String> attributes) {
        Preconditions.checkNotNull(xmlBlockDedupers);
        Preconditions.checkNotNull((Object)elementName);
        Preconditions.checkNotNull(attributes);
        this.findAndReplace = null;
        this.xmlBlockDedupers = xmlBlockDedupers;
        this.elementName = elementName;
        this.attributes = ImmutableList.builder().addAll((Iterable)attributes.entrySet().stream().map(attribute -> xmlEventFactory.createAttribute((String)attribute.getKey(), (String)attribute.getValue())).collect(Collectors.toList())).build();
    }

    private void preMerge(XMLEventWriter xmlEventWriter) throws XMLStreamException {
        xmlEventWriter.add(xmlEventFactory.createStartElement("", "", this.elementName, this.attributes.iterator(), null));
    }

    private void postMerge(XMLEventWriter xmlEventWriter) throws XMLStreamException {
        xmlEventWriter.add(xmlEventFactory.createEndElement("", "", this.elementName));
    }

    public void merge(OutputStream writer, List<InputStream> streams) throws XMLStreamException {
        Preconditions.checkNotNull((Object)writer);
        Preconditions.checkNotNull(streams);
        if (streams.size() == 1) {
            this.copyOfInputStream(writer, streams.get(0));
            return;
        }
        if (this.findAndReplace == null) {
            this.mergeStreams(writer, streams);
        } else {
            this.mergeStreamsAndUpdate(writer, streams);
        }
    }

    private void mergeStreamsAndUpdate(OutputStream writer, List<InputStream> streams) throws XMLStreamException {
        File tempFile = null;
        try {
            try {
                tempFile = File.createTempFile("temp", "xml");
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));){
                    int packageCount = this.mergeStreams(outputStream, streams);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(tempFile));){
                        this.updatePackageCount(inputStream, writer, packageCount);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create temporary file", e);
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private int mergeStreams(OutputStream outputStream, List<InputStream> streams) throws XMLStreamException {
        int packageCount;
        try (XMLEventWriter xmlEventWriter = xmlOutputFactory.createXMLEventWriter(outputStream);){
            xmlEventWriter.add(xmlEventFactory.createStartDocument());
            this.preMerge(xmlEventWriter);
            packageCount = this.merge(xmlEventWriter, streams);
            this.postMerge(xmlEventWriter);
        }
        return packageCount;
    }

    private void copyOfInputStream(OutputStream outputStream, InputStream inputStream) {
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy when only a single input stream", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updatePackageCount(InputStream inputStream, OutputStream outputStream, int packageCount) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            BufferedInputStream tempFileInputStream = new BufferedInputStream(inputStream);
            try {
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                    this.findAndReplace.replace(tempFileInputStream, bufferedOutputStream, Integer.toString(packageCount));
                }
                if (tempFileInputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (tempFileInputStream == null) throw throwable;
                tempFileInputStream.close();
                throw throwable;
            }
            tempFileInputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private int merge(XMLEventWriter xmlEventWriter, List<InputStream> streams) {
        this.xmlBlockDedupers.forEach(XmlBlockDeduper::clear);
        for (InputStream inputStream : streams) {
            XMLEventReader xmlEventReader = null;
            try {
                try {
                    xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream);
                    XmlBlockDeduper xmlBlockDeduper = null;
                    while (xmlEventReader.hasNext()) {
                        XMLEvent xmlEvent = xmlEventReader.nextEvent();
                        if (this.isStartOfNewBlock(xmlBlockDeduper, xmlEvent)) {
                            xmlBlockDeduper = this.findDeduper(this.xmlBlockDedupers, xmlEvent);
                            if (xmlBlockDeduper == null) continue;
                            this.packageEvents.add(xmlEvent);
                            continue;
                        }
                        if (this.isEndOfCurrentBlock(xmlBlockDeduper, xmlEvent)) {
                            this.packageEvents.add(xmlEvent);
                            this.addIfUnique(xmlEventWriter, xmlBlockDeduper);
                            this.packageEvents.clear();
                            xmlBlockDeduper = null;
                            continue;
                        }
                        if (!this.isAlreadyDeduping(xmlBlockDeduper)) continue;
                        this.packageEvents.add(xmlBlockDeduper.process(xmlEvent));
                    }
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.closeReader(xmlEventReader);
            }
        }
        this.xmlBlockDedupers.forEach(deduper -> deduper.postProcess(xmlEventWriter));
        return this.xmlBlockDedupers.stream().mapToInt(XmlBlockDeduper::uniqueBlockCount).sum();
    }

    private boolean isAlreadyDeduping(XmlBlockDeduper xmlBlockDeduper) {
        return xmlBlockDeduper != null;
    }

    private void addIfUnique(XMLEventWriter xmlEventWriter, XmlBlockDeduper xmlBlockDeduper) {
        if (xmlBlockDeduper.isUnique(this.packageEvents)) {
            this.addPackage(xmlEventWriter, this.packageEvents);
        }
    }

    private void closeReader(XMLEventReader xmlEventReader) {
        if (xmlEventReader != null) {
            try {
                xmlEventReader.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Unable to close the xmlEventReader", e);
            }
        }
    }

    @Nullable
    private XmlBlockDeduper findDeduper(List<XmlBlockDeduper> xmlBlockDedupers, XMLEvent xmlEvent) {
        return xmlBlockDedupers.stream().filter(deduper -> deduper.isBlockStart(xmlEvent)).findFirst().orElse(null);
    }

    private boolean isStartOfNewBlock(@Nullable XmlBlockDeduper xmlBlockDeduper, XMLEvent xmlEvent) {
        return xmlBlockDeduper == null && xmlEvent.isStartElement();
    }

    private boolean isEndOfCurrentBlock(@Nullable XmlBlockDeduper xmlBlockDeduper, XMLEvent xmlEvent) {
        return xmlBlockDeduper != null && xmlBlockDeduper.isBlockEnd(xmlEvent);
    }

    private void addPackage(XMLEventWriter writer, List<XMLEvent> xmlEvents) {
        xmlEvents.forEach(event -> {
            try {
                writer.add((XMLEvent)event);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

