/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import com.google.common.hash.HashCode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.utils.YumFacetUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Singleton
@Named
public class RepomdChecksumAndSizeUpdater
extends ComponentSupport {
    private static final String CHECKSUM = "repomd/data[@type='primary']/checksum/text()";
    private static final String SIZE = "repomd/data[@type='primary']/size/text()";
    private static final String OPEN_CHECKSUM = "repomd/data[@type='primary']/open-checksum/text()";
    private static final String OPEN_SIZE = "repomd/data[@type='primary']/open-size/text()";

    public void update(Document repomdXml, YumMetadata primaryMetadata, @Nullable Content primaryXml) {
        if (primaryXml != null) {
            Asset asset = (Asset)primaryXml.getAttributes().get("org.sonatype.nexus.repository.storage.Asset");
            Map attributes = (Map)asset.attributes().get("yum");
            if (this.isPrimaryXmlModified(attributes)) {
                this.updateElement(CHECKSUM, repomdXml, this.checksum(primaryMetadata, asset));
                this.updateElement(SIZE, repomdXml, Long.toString(asset.size()));
                this.updateElement(OPEN_CHECKSUM, repomdXml, this.openChecksum(primaryMetadata, attributes));
                this.updateElement(OPEN_SIZE, repomdXml, this.openSize(attributes));
            }
        } else {
            this.log.warn("Unable to update checksum and size for primary file because primary could not be retrieved: {}", (Object)primaryMetadata.getLocation());
        }
    }

    @Nullable
    private String checksum(YumMetadata primaryMetadata, Asset asset) {
        return Optional.ofNullable(primaryMetadata.getChecksum()).map(checksum -> asset.getChecksum(YumFacetUtils.hashAlgorithmByName(checksum))).map(HashCode::toString).orElse(null);
    }

    @Nullable
    private String openChecksum(YumMetadata primaryMetadata, Map attributes) {
        String openChecksumType = primaryMetadata.getOpenChecksum();
        return this.openAttributeFor(openChecksumType, attributes);
    }

    @Nullable
    private String openSize(Map attributes) {
        return this.openAttributeFor("size", attributes);
    }

    @Nullable
    private String openAttributeFor(String key, Map attributes) {
        return Optional.ofNullable(attributes.get("open-" + key)).map(Objects::toString).orElse(null);
    }

    private boolean isPrimaryXmlModified(Map attributes) {
        return attributes.get("modified") != null;
    }

    private void updateElement(String expression, Document document, @Nullable String value) {
        if (value != null) {
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node element = (Node)xPath.evaluate(expression, document, XPathConstants.NODE);
                if (element != null) {
                    element.setNodeValue(value);
                }
            }
            catch (XPathExpressionException e) {
                this.log.error("Unable to update repomd xml", (Throwable)e);
            }
        }
    }
}

