/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadataType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Named
@Singleton
public class RepomdParser {
    private static final String TYPE = "repomd/data[@type='%s']";
    private static final String LOCATION = "repomd/data[@type='%s']/location/@href";
    private static final String CHECKSUM = "repomd/data[@type='%s']/checksum/@type";
    private static final String OPEN_CHECKSUM = "repomd/data[@type='%s']/open-checksum/@type";

    public YumMetadata parse(Document repomd) {
        String primaryType = YumMetadataType.PRIMARY.getType();
        return new YumMetadata(YumMetadataType.PRIMARY).setLocation(this.extract(String.format(LOCATION, primaryType), repomd)).setChecksum(this.extract(String.format(CHECKSUM, primaryType), repomd)).setOpenChecksum(this.extract(String.format(OPEN_CHECKSUM, primaryType), repomd));
    }

    public Map<YumMetadataType, YumMetadata> parseAll(Document repomd) {
        HashMap<YumMetadataType, YumMetadata> metadataMap = new HashMap<YumMetadataType, YumMetadata>();
        ImmutableList.of((Object)((Object)YumMetadataType.PRIMARY), (Object)((Object)YumMetadataType.FILELISTS), (Object)((Object)YumMetadataType.OTHER), (Object)((Object)YumMetadataType.COMPS_GZ), (Object)((Object)YumMetadataType.COMPS)).forEach(metadataType -> {
            if (this.present(metadataType.getType(), repomd)) {
                metadataMap.put((YumMetadataType)((Object)metadataType), this.parseType((YumMetadataType)((Object)metadataType), repomd));
            }
        });
        return metadataMap;
    }

    private YumMetadata parseType(YumMetadataType metadataType, Document repomd) {
        return new YumMetadata(metadataType).setLocation(this.extract(String.format(LOCATION, metadataType.getType()), repomd)).setChecksum(this.extract(String.format(CHECKSUM, metadataType.getType()), repomd)).setOpenChecksum(this.extract(String.format(OPEN_CHECKSUM, metadataType.getType()), repomd));
    }

    private boolean present(String type, Document from) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            return xPath.evaluate(String.format(TYPE, type), from, XPathConstants.NODE) != null;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return false;
        }
    }

    @Nullable
    private String extract(String path, Document from) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xPath.evaluate(path, from, XPathConstants.NODE);
            return node == null ? null : node.getNodeValue();
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }
}

