/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdChecksumAndSizeUpdater;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdParser;
import org.sonatype.nexus.repository.yum.internal.metadata.SqliteRemover;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;
import org.w3c.dom.Document;

@Named
@Singleton
public class RepomdProcessor
extends ComponentSupport {
    private final SqliteRemover sqliteRemover;
    private final RepomdParser repomdParser;
    private final RepomdChecksumAndSizeUpdater checksumUpdater;

    @Inject
    public RepomdProcessor(RepomdParser repomdParser, SqliteRemover sqliteRemover, RepomdChecksumAndSizeUpdater checksumUpdater) {
        this.repomdParser = (RepomdParser)Preconditions.checkNotNull((Object)repomdParser);
        this.sqliteRemover = (SqliteRemover)((Object)Preconditions.checkNotNull((Object)((Object)sqliteRemover)));
        this.checksumUpdater = (RepomdChecksumAndSizeUpdater)((Object)Preconditions.checkNotNull((Object)((Object)checksumUpdater)));
    }

    public void process(Document repomdXml, MetadataFetcher metadataFetcher) {
        YumMetadata primaryMetadata = this.repomdParser.parse(repomdXml);
        this.sqliteRemover.removeSqliteEntries(repomdXml);
        Optional.ofNullable(primaryMetadata.getLocation()).ifPresent(primaryXml -> this.checksumUpdater.update(repomdXml, primaryMetadata, metadataFetcher.fetch((String)primaryXml)));
    }

    public static interface MetadataFetcher {
        public Content fetch(String var1);
    }
}

